/*
 * Decompiled with CFR 0.152.
 */
package io.datarouter.changelog.storage;

import io.datarouter.changelog.storage.Changelog;
import io.datarouter.changelog.storage.ChangelogKey;
import io.datarouter.model.databean.Databean;
import io.datarouter.model.key.primary.PrimaryKey;
import io.datarouter.scanner.Scanner;
import io.datarouter.storage.Datarouter;
import io.datarouter.storage.client.ClientId;
import io.datarouter.storage.dao.BaseDao;
import io.datarouter.storage.dao.BaseRedundantDaoParams;
import io.datarouter.storage.node.factory.NodeFactory;
import io.datarouter.storage.node.op.combo.SortedMapStorage;
import io.datarouter.util.tuple.Range;
import io.datarouter.virtualnode.redundant.RedundantSortedMapStorageNode;
import java.util.List;
import java.util.Optional;
import javax.inject.Inject;
import javax.inject.Singleton;

@Singleton
public class ChangelogDao
extends BaseDao {
    private final SortedMapStorage.SortedMapStorageNode<ChangelogKey, Changelog, Changelog.ChangelogFielder> node;

    @Inject
    public ChangelogDao(Datarouter datarouter, ChangelogDaoParams params, NodeFactory nodeFactory) {
        super(datarouter);
        this.node = (SortedMapStorage.SortedMapStorageNode)Scanner.of((Iterable)params.clientIds).map(clientId -> {
            SortedMapStorage.SortedMapStorageNode node = (SortedMapStorage.SortedMapStorageNode)nodeFactory.create(clientId, Changelog::new, Changelog.ChangelogFielder::new).withIsSystemTable(true).build();
            return node;
        }).listTo(RedundantSortedMapStorageNode::new);
        datarouter.register(this.node);
    }

    public Optional<Changelog> find(ChangelogKey key) {
        return this.node.find((PrimaryKey)key);
    }

    public void put(Changelog databean) {
        this.node.put((Databean)databean);
    }

    public Scanner<Changelog> scan() {
        return this.node.scan();
    }

    public Scanner<Changelog> scan(Range<ChangelogKey> range) {
        return this.node.scan(range);
    }

    public Changelog get(ChangelogKey key) {
        return (Changelog)this.node.get((PrimaryKey)key);
    }

    public static class ChangelogDaoParams
    extends BaseRedundantDaoParams {
        public ChangelogDaoParams(List<ClientId> clientIds) {
            super(clientIds);
        }
    }
}

