/*
 * Decompiled with CFR 0.152.
 */
package io.datarouter.changelog.storage;

import io.datarouter.changelog.storage.ChangelogKey;
import io.datarouter.instrumentation.changelog.ChangelogDto;
import io.datarouter.model.databean.BaseDatabean;
import io.datarouter.model.field.Field;
import io.datarouter.model.field.imp.StringField;
import io.datarouter.model.field.imp.StringFieldKey;
import io.datarouter.model.key.primary.PrimaryKey;
import io.datarouter.model.serialize.fielder.BaseDatabeanFielder;
import java.util.List;

public class Changelog
extends BaseDatabean<ChangelogKey, Changelog> {
    private String action;
    private String username;
    private String comment;
    private String note;

    public Changelog() {
        super((PrimaryKey)new ChangelogKey());
    }

    public Changelog(ChangelogDto dto) {
        super((PrimaryKey)new ChangelogKey(dto.getReversedDateMs(), dto.changelogType, dto.name));
        this.action = dto.action;
        this.username = dto.username;
        this.comment = dto.comment;
        this.note = dto.note;
    }

    public Class<ChangelogKey> getKeyClass() {
        return ChangelogKey.class;
    }

    public String getAction() {
        return this.action;
    }

    public String getUsername() {
        return this.username;
    }

    public String getComment() {
        return this.comment;
    }

    public String getNote() {
        return this.note;
    }

    public void setNote(String note) {
        this.note = note;
    }

    public ChangelogDto toDto(String serviceName) {
        return new ChangelogDto(serviceName, ((ChangelogKey)this.getKey()).getChangelogType(), ((ChangelogKey)this.getKey()).getName(), Long.MAX_VALUE - ((ChangelogKey)this.getKey()).getReversedDateMs(), this.action, this.username, this.comment, this.note);
    }

    public static class ChangelogFielder
    extends BaseDatabeanFielder<ChangelogKey, Changelog> {
        public ChangelogFielder() {
            super(ChangelogKey.class);
        }

        public List<Field<?>> getNonKeyFields(Changelog databean) {
            return List.of(new StringField(FieldKeys.action, databean.action), new StringField(FieldKeys.username, databean.username), new StringField(FieldKeys.comment, databean.comment), new StringField(FieldKeys.note, databean.note));
        }
    }

    public static class FieldKeys {
        public static final StringFieldKey action = new StringFieldKey("action");
        public static final StringFieldKey username = new StringFieldKey("username");
        public static final StringFieldKey comment = new StringFieldKey("comment").withSize(65535);
        public static final StringFieldKey note = new StringFieldKey("note").withSize(65535);
    }
}

