/*
 * Decompiled with CFR 0.152.
 */
package io.datarouter.changelog.service;

import io.datarouter.changelog.config.DatarouterChangelogPaths;
import io.datarouter.email.email.DatarouterHtmlEmailService;
import io.datarouter.email.html.J2HtmlDatarouterEmailBuilder;
import io.datarouter.email.html.J2HtmlEmailTable;
import io.datarouter.httpclient.client.DatarouterService;
import io.datarouter.instrumentation.changelog.ChangelogRecorder;
import io.datarouter.storage.config.DatarouterAdministratorEmailService;
import io.datarouter.storage.config.DatarouterProperties;
import io.datarouter.util.tuple.Twin;
import j2html.TagCreator;
import j2html.tags.ContainerTag;
import j2html.tags.DomContent;
import java.util.ArrayList;
import java.util.List;
import javax.inject.Inject;
import javax.inject.Singleton;

@Singleton
public class ChangelogEmailService {
    @Inject
    private DatarouterService datarouterService;
    @Inject
    private DatarouterHtmlEmailService htmlEmailService;
    @Inject
    private DatarouterProperties datarouterProperties;
    @Inject
    private DatarouterAdministratorEmailService additionalAdministratorEmailService;
    @Inject
    private DatarouterChangelogPaths paths;

    public void sendEmail(ChangelogRecorder.DatarouterChangelogDto dto) {
        String from = this.datarouterProperties.getAdministratorEmail();
        ArrayList<String> toEmails = new ArrayList<String>();
        toEmails.add(dto.username);
        if (dto.includeMainDatarouterAdmin) {
            toEmails.add(this.datarouterProperties.getAdministratorEmail());
        }
        if (dto.includeAdditionalAdministrators) {
            toEmails.addAll(this.additionalAdministratorEmailService.getAdditionalAdministratorOnly(new String[0]));
        }
        String to = String.join((CharSequence)",", toEmails);
        String primaryHref = this.htmlEmailService.startLinkBuilder().withLocalPath(this.paths.datarouter.changelog.viewAll).build();
        J2HtmlDatarouterEmailBuilder emailBuilder = this.htmlEmailService.startEmailBuilder().withTitle("Changelog - " + dto.changelogType).withTitleHref(primaryHref).withContent(this.makeEmailContent(dto.changelogType, dto.name, dto.action, dto.username, dto.comment.orElse("")));
        this.htmlEmailService.trySendJ2Html(from, to, emailBuilder);
    }

    private ContainerTag makeEmailContent(String changelogType, String name, String action, String username, String comment) {
        List<Twin> rows = List.of(new Twin((Object)"Service", (Object)this.datarouterService.getServiceName()), new Twin((Object)"ServerName", (Object)this.datarouterProperties.getServerName()), new Twin((Object)"ChangelogType", (Object)changelogType), new Twin((Object)"Name", (Object)name), new Twin((Object)"Action", (Object)action), new Twin((Object)"Username", (Object)username), new Twin((Object)"Comment", (Object)comment));
        return new J2HtmlEmailTable().withColumn(new J2HtmlEmailTable.J2HtmlEmailTableColumn(null, row -> ChangelogEmailService.makeDivBoldRight((String)row.getLeft()))).withColumn(new J2HtmlEmailTable.J2HtmlEmailTableColumn(null, row -> ChangelogEmailService.makeSpanWhiteSpacePre((String)row.getRight()))).build(rows);
    }

    private static DomContent makeDivBoldRight(String text) {
        return TagCreator.div((String)text).withStyle("font-weight:bold;text-align:right;");
    }

    private static DomContent makeSpanWhiteSpacePre(String text) {
        return TagCreator.span((String)text).withStyle("white-space:pre");
    }
}

