/*
 * Decompiled with CFR 0.152.
 */
package io.datarouter.changelog.service;

import io.datarouter.changelog.config.DatarouterChangelogSettingRoot;
import io.datarouter.changelog.service.ChangelogEmailService;
import io.datarouter.changelog.storage.Changelog;
import io.datarouter.changelog.storage.ChangelogDao;
import io.datarouter.httpclient.client.DatarouterService;
import io.datarouter.instrumentation.changelog.ChangelogDto;
import io.datarouter.instrumentation.changelog.ChangelogPublisher;
import io.datarouter.instrumentation.changelog.ChangelogRecorder;
import java.util.Date;
import java.util.Optional;
import javax.inject.Inject;
import javax.inject.Singleton;

@Singleton
public class ChangelogRecorderService
implements ChangelogRecorder {
    @Inject
    private ChangelogPublisher publisher;
    @Inject
    private DatarouterService datarouterService;
    @Inject
    private DatarouterChangelogSettingRoot settings;
    @Inject
    private ChangelogDao dao;
    @Inject
    private ChangelogEmailService emailService;

    public void record(String changelogType, String name, String action, String username, String comment, String note) {
        ChangelogDto dto = new ChangelogDto(this.datarouterService.getServiceName(), changelogType, name, new Date().getTime(), action, username, comment, note);
        if (((Boolean)this.settings.publishChangelog.get()).booleanValue()) {
            this.publisher.add(dto);
        }
        this.dao.put(new Changelog(dto));
    }

    public void recordAndSendEmail(String changelogType, String name, String action, String username, Optional<String> comment, Optional<String> note, Optional<String> additionalSendTos) {
        this.record(changelogType, name, action, username, comment.orElse(null), note.orElse(null));
        this.emailService.sendEmail(changelogType, name, action, username, additionalSendTos, comment);
    }

    public void update(ChangelogDto changelogDto) {
        if (((Boolean)this.settings.publishChangelog.get()).booleanValue()) {
            this.publisher.add(changelogDto);
        }
        this.dao.put(new Changelog(changelogDto));
    }
}

