/*
 * Decompiled with CFR 0.152.
 */
package io.datarouter.changelog.service;

import io.datarouter.changelog.config.DatarouterChangelogPaths;
import io.datarouter.changelog.service.ViewChangelogService;
import io.datarouter.changelog.storage.Changelog;
import io.datarouter.changelog.storage.ChangelogDao;
import io.datarouter.changelog.storage.ChangelogKey;
import io.datarouter.httpclient.client.DatarouterService;
import io.datarouter.util.DateTool;
import io.datarouter.util.tuple.Range;
import io.datarouter.web.digest.DailyDigest;
import io.datarouter.web.digest.DailyDigestGrouping;
import io.datarouter.web.digest.DailyDigestService;
import io.datarouter.web.html.email.J2HtmlEmailTable;
import j2html.TagCreator;
import j2html.tags.ContainerTag;
import j2html.tags.DomContent;
import java.time.ZoneId;
import java.util.Date;
import java.util.List;
import java.util.Optional;
import javax.inject.Inject;
import javax.inject.Singleton;

@Singleton
public class ChangelogDailyDigest
implements DailyDigest {
    @Inject
    private ChangelogDao dao;
    @Inject
    private DailyDigestService digestService;
    @Inject
    private DatarouterChangelogPaths paths;
    @Inject
    private ViewChangelogService viewChangelogService;
    @Inject
    private DatarouterService datarouterService;

    public Optional<ContainerTag> getPageContent(ZoneId zoneId) {
        List<Changelog> list = this.getChangelogs();
        if (list.size() == 0) {
            return Optional.empty();
        }
        ContainerTag header = this.digestService.makeHeader("Changelog", this.paths.datarouter.changelog.viewAll);
        ContainerTag description = TagCreator.small((String)"For the current day");
        ContainerTag table = this.viewChangelogService.buildTable(list, zoneId);
        return Optional.of(TagCreator.div((DomContent[])new DomContent[]{header, description, table}));
    }

    public Optional<ContainerTag> getEmailContent() {
        List<Changelog> list = this.getChangelogs();
        if (list.size() == 0) {
            return Optional.empty();
        }
        ContainerTag header = this.digestService.makeHeader("Changelog", this.paths.datarouter.changelog.viewAll);
        ContainerTag description = TagCreator.small((String)"For the current day");
        ContainerTag table = this.buildEmailTable(list);
        return Optional.of(TagCreator.div((DomContent[])new DomContent[]{header, description, table}));
    }

    public String getTitle() {
        return "Changelog";
    }

    public DailyDigestGrouping getGrouping() {
        return DailyDigestGrouping.LOW;
    }

    private List<Changelog> getChangelogs() {
        ChangelogKey start = new ChangelogKey(DateTool.atEndOfDayReversedMs(), null, null);
        ChangelogKey stop = new ChangelogKey(DateTool.atStartOfDayReversedMs(), null, null);
        Range range = new Range((Comparable)((Object)start), true, (Comparable)((Object)stop), true);
        return this.dao.scan((Range<ChangelogKey>)range).list();
    }

    private ContainerTag buildEmailTable(List<Changelog> rows) {
        ZoneId zoneId = this.datarouterService.getZoneId();
        return new J2HtmlEmailTable().withColumn(new J2HtmlEmailTable.J2HtmlEmailTableColumn("", row -> {
            String href = String.valueOf(this.paths.datarouter.changelog.viewExact.toSlashedString()) + "?" + "reversedDateMs" + "=" + ((ChangelogKey)row.getKey()).getReversedDateMs() + "&" + "changelogType" + "=" + ((ChangelogKey)row.getKey()).getChangelogType() + "&" + "name" + "=" + ((ChangelogKey)row.getKey()).getName();
            return this.digestService.makeATagLink("#", href);
        })).withColumn("Date", row -> {
            Long reversedDateMs = ((ChangelogKey)row.getKey()).getReversedDateMs();
            return DateTool.formatDateWithZone((Date)new Date(Long.MAX_VALUE - reversedDateMs), (ZoneId)zoneId);
        }).withColumn("Type", row -> ((ChangelogKey)row.getKey()).getChangelogType()).withColumn("Name", row -> ((ChangelogKey)row.getKey()).getName()).withColumn("Action", row -> row.getAction()).withColumn("User", row -> row.getUsername()).build(rows);
    }
}

