/*
 * Decompiled with CFR 0.152.
 */
package io.datarouter.changelog.web;

import io.datarouter.changelog.config.DatarouterChangelogPaths;
import io.datarouter.changelog.storage.Changelog;
import io.datarouter.changelog.storage.ChangelogDao;
import io.datarouter.changelog.storage.ChangelogKey;
import io.datarouter.util.number.RandomTool;
import io.datarouter.web.handler.BaseHandler;
import io.datarouter.web.handler.mav.Mav;
import io.datarouter.web.html.j2html.J2HtmlTable;
import io.datarouter.web.html.j2html.bootstrap4.Bootstrap4PageFactory;
import io.datarouter.web.html.pager.Bootstrap4PagerHtml;
import io.datarouter.web.html.pager.MemoryPager;
import io.datarouter.web.html.pager.MemorySorter;
import j2html.TagCreator;
import j2html.tags.ContainerTag;
import j2html.tags.DomContent;
import java.util.Collection;
import java.util.Collections;
import java.util.Date;
import javax.inject.Inject;

public class ViewChangelogHandler
extends BaseHandler {
    @Inject
    private Bootstrap4PageFactory pageFactory;
    @Inject
    private ChangelogDao dao;
    @Inject
    private DatarouterChangelogPaths paths;

    @BaseHandler.Handler(defaultHandler=true)
    public Mav view() {
        MemoryPager pager = new MemoryPager(Collections.emptyList(), new MemorySorter(), String.valueOf(this.request.getContextPath()) + this.paths.datarouter.changelog.view.toSlashedString(), this.params, 100);
        MemoryPager.Page page = pager.collect(this.dao.scan());
        return this.pageFactory.startBuilder(this.request).withTitle("Changelog").withContent(ViewChangelogHandler.makeContent((MemoryPager.Page<Changelog>)page)).buildMav();
    }

    private static ContainerTag makeContent(MemoryPager.Page<Changelog> page) {
        ContainerTag form = (ContainerTag)Bootstrap4PagerHtml.renderForm(page).withClass("mt-4");
        ContainerTag linkBar = (ContainerTag)Bootstrap4PagerHtml.renderLinkBar(page).withClass("mt-2");
        ContainerTag table = new J2HtmlTable().withClasses(new String[]{"table table-sm table-striped my-4 border"}).withColumn("Date", row -> {
            Long reversedDateMs = ((ChangelogKey)row.getKey()).getReversedDateMs();
            return new Date(Long.MAX_VALUE - reversedDateMs);
        }).withColumn("Type", row -> ((ChangelogKey)row.getKey()).getChangelogType()).withColumn("Name", row -> ((ChangelogKey)row.getKey()).getName()).withColumn("Action", row -> row.getAction()).withColumn("User", row -> row.getUsername()).withHtmlColumn("Comment", row -> {
            String id = "" + ((ChangelogKey)row.getKey()).getReversedDateMs() + RandomTool.nextPositiveInt();
            return ViewChangelogHandler.makeCommentModal(id, row.getComment());
        }).build((Collection)page.rows);
        return (ContainerTag)TagCreator.div((DomContent[])new DomContent[]{form, linkBar, table}).withClass("container-fluid");
    }

    public static DomContent makeCommentModal(String id, String comment) {
        if (comment == null) {
            return TagCreator.td();
        }
        String modalId = "commentModal" + id;
        ContainerTag commentButton = (ContainerTag)((ContainerTag)((ContainerTag)((ContainerTag)TagCreator.a().withClass("fa fa-sticky-note")).attr("data-toggle", (Object)"modal")).attr("data-target", (Object)("#" + modalId))).withHref("#" + modalId);
        ContainerTag modalBody = (ContainerTag)((ContainerTag)TagCreator.div((String)comment).withClass("modal-body")).withStyle("text-align:left");
        ContainerTag modalFooter = (ContainerTag)TagCreator.div((DomContent[])new DomContent[]{((ContainerTag)((ContainerTag)TagCreator.button((String)"Close").withType("button")).withClass("btn btn-secondary")).attr("data-dismiss", (Object)"modal")}).withClass("modal-footer");
        ContainerTag modalContent = (ContainerTag)TagCreator.div((DomContent[])new DomContent[]{modalBody, modalFooter}).withClass("modal-content");
        ContainerTag modalDialog = (ContainerTag)((ContainerTag)TagCreator.div((DomContent[])new DomContent[]{modalContent}).withClass("modal-dialog")).withRole("document");
        ContainerTag modal = (ContainerTag)((ContainerTag)((ContainerTag)((ContainerTag)TagCreator.div((DomContent[])new DomContent[]{modalDialog}).withClass("modal fade")).withId(modalId)).attr("tabindex", (Object)"-1")).withRole("dialog");
        return TagCreator.td((DomContent[])new DomContent[]{TagCreator.div((DomContent[])new DomContent[]{commentButton, modal})}).withStyle("text-align:center");
    }
}

