/*
 * Decompiled with CFR 0.152.
 */
package io.datarouter.changelog.config;

import io.datarouter.changelog.config.DatarouterChangelogPaths;
import io.datarouter.changelog.config.DatarouterChangelogRouteSet;
import io.datarouter.changelog.config.DatarouterChangelogSettingRoot;
import io.datarouter.changelog.service.ChangelogRecorderService;
import io.datarouter.changelog.storage.ChangelogDao;
import io.datarouter.instrumentation.changelog.ChangelogPublisher;
import io.datarouter.instrumentation.changelog.ChangelogRecorder;
import io.datarouter.storage.client.ClientId;
import io.datarouter.storage.dao.Dao;
import io.datarouter.storage.dao.DaosModuleBuilder;
import io.datarouter.web.config.BaseWebPlugin;
import io.datarouter.web.navigation.DatarouterNavBarCategory;
import io.datarouter.web.navigation.NavBarCategory;
import java.util.List;

public class DatarouterChangelogPlugin
extends BaseWebPlugin {
    private static final DatarouterChangelogPaths PATHS = new DatarouterChangelogPaths();
    private final Class<? extends ChangelogPublisher> changelogPublisher;

    private DatarouterChangelogPlugin(Class<? extends ChangelogPublisher> changelogPublisher, DatarouterChangelogDaosModule daosModule) {
        this.changelogPublisher = changelogPublisher;
        this.addSettingRoot(DatarouterChangelogSettingRoot.class);
        this.addRouteSet(DatarouterChangelogRouteSet.class);
        this.setDaosModule(daosModule);
        this.addDatarouterNavBarItem((NavBarCategory)DatarouterNavBarCategory.CHANGELOG, DatarouterChangelogPlugin.PATHS.datarouter.changelog.view, "View Changelog");
        this.addDatarouterNavBarItem((NavBarCategory)DatarouterNavBarCategory.CHANGELOG, DatarouterChangelogPlugin.PATHS.datarouter.changelog.insert, "Add");
    }

    public String getName() {
        return "DatarouterChangelog";
    }

    protected void configure() {
        this.bind(ChangelogPublisher.class).to(this.changelogPublisher);
        this.bindActual(ChangelogRecorder.class, ChangelogRecorderService.class);
    }

    public static class DatarouterChangelogDaosModule
    extends DaosModuleBuilder {
        private final ClientId changelogClientId;

        public DatarouterChangelogDaosModule(ClientId changelogClientId) {
            this.changelogClientId = changelogClientId;
        }

        public List<Class<? extends Dao>> getDaoClasses() {
            return List.of(ChangelogDao.class);
        }

        public void configure() {
            this.bind(ChangelogDao.ChangelogDaoParams.class).toInstance((Object)new ChangelogDao.ChangelogDaoParams(this.changelogClientId));
        }
    }

    public static class DatarouterChangelogPluginBuilder {
        private final ClientId defaultClientId;
        private Class<? extends ChangelogPublisher> changelogPublisher = ChangelogPublisher.NoOpChangelogPublisher.class;

        public DatarouterChangelogPluginBuilder(ClientId defaultClientId) {
            this.defaultClientId = defaultClientId;
        }

        public DatarouterChangelogPluginBuilder enableChangelogPublishing(Class<? extends ChangelogPublisher> changelogPublisher) {
            this.changelogPublisher = changelogPublisher;
            return this;
        }

        public DatarouterChangelogPlugin build() {
            return new DatarouterChangelogPlugin(this.changelogPublisher, new DatarouterChangelogDaosModule(this.defaultClientId));
        }
    }
}

