/*
 * Decompiled with CFR 0.152.
 */
package io.datarouter.changelog.service;

import io.datarouter.changelog.config.DatarouterChangelogPaths;
import io.datarouter.httpclient.client.DatarouterService;
import io.datarouter.storage.config.DatarouterAdministratorEmailService;
import io.datarouter.storage.config.DatarouterProperties;
import io.datarouter.util.tuple.Twin;
import io.datarouter.web.email.DatarouterHtmlEmailService;
import io.datarouter.web.html.email.J2HtmlDatarouterEmailBuilder;
import io.datarouter.web.html.email.J2HtmlEmailTable;
import j2html.TagCreator;
import j2html.tags.ContainerTag;
import j2html.tags.DomContent;
import java.util.Arrays;
import java.util.List;
import java.util.Optional;
import javax.inject.Inject;
import javax.inject.Singleton;

@Singleton
public class ChangelogEmailService {
    @Inject
    private DatarouterService datarouterService;
    @Inject
    private DatarouterHtmlEmailService htmlEmailService;
    @Inject
    private DatarouterProperties datarouterProperties;
    @Inject
    private DatarouterAdministratorEmailService additionalAdministratorEmailService;
    @Inject
    private DatarouterChangelogPaths paths;

    public void sendEmail(String changelogType, String name, String action, String username, Optional<String> toEmailParam, Optional<String> comment) {
        String from = this.datarouterProperties.getAdministratorEmail();
        List toEmails = this.additionalAdministratorEmailService.getAdministratorEmailAddresses();
        toEmails.add(username);
        toEmailParam.map(email -> email.split(",")).map(Arrays::stream).ifPresent(stream -> stream.forEach(toEmails::add));
        String to = String.join((CharSequence)",", toEmails);
        String primaryHref = this.htmlEmailService.startLinkBuilder().withLocalPath(this.paths.datarouter.changelog.view).build();
        J2HtmlDatarouterEmailBuilder emailBuilder = this.htmlEmailService.startEmailBuilder().withSubject("Changelog - " + changelogType + " - " + this.datarouterService.getName()).withTitle("Changelog - " + changelogType).withTitleHref(primaryHref).withContent(this.makeEmailContent(changelogType, name, action, username, comment.orElse("")));
        this.htmlEmailService.trySendJ2Html(from, to, emailBuilder);
    }

    private ContainerTag makeEmailContent(String changelogType, String name, String action, String username, String comment) {
        List<Twin> rows = List.of(new Twin((Object)"Service", (Object)this.datarouterService.getName()), new Twin((Object)"ServerName", (Object)this.datarouterProperties.getServerName()), new Twin((Object)"ChangelogType", (Object)changelogType), new Twin((Object)"Name", (Object)name), new Twin((Object)"Action", (Object)action), new Twin((Object)"Username", (Object)username), new Twin((Object)"Comment", (Object)comment));
        return new J2HtmlEmailTable().withColumn(new J2HtmlEmailTable.J2HtmlEmailTableColumn(null, row -> ChangelogEmailService.makeDivBoldRight((String)row.getLeft()))).withColumn(new J2HtmlEmailTable.J2HtmlEmailTableColumn(null, row -> TagCreator.text((String)((String)row.getRight())))).build(rows);
    }

    private static DomContent makeDivBoldRight(String text) {
        return TagCreator.div((String)text).withStyle("font-weight:bold;text-align:right;");
    }
}

