/*
 * Decompiled with CFR 0.152.
 */
package io.datarouter.changelog.web;

import io.datarouter.changelog.config.DatarouterChangelogPaths;
import io.datarouter.httpclient.client.DatarouterService;
import io.datarouter.instrumentation.changelog.ChangelogRecorder;
import io.datarouter.storage.config.DatarouterAdministratorEmailService;
import io.datarouter.storage.config.DatarouterProperties;
import io.datarouter.util.tuple.Twin;
import io.datarouter.web.email.DatarouterHtmlEmailService;
import io.datarouter.web.handler.BaseHandler;
import io.datarouter.web.handler.mav.Mav;
import io.datarouter.web.handler.types.Param;
import io.datarouter.web.handler.types.optional.OptionalString;
import io.datarouter.web.html.email.J2HtmlDatarouterEmailBuilder;
import io.datarouter.web.html.email.J2HtmlEmailTable;
import io.datarouter.web.html.form.HtmlForm;
import io.datarouter.web.html.j2html.bootstrap4.Bootstrap4FormHtml;
import io.datarouter.web.html.j2html.bootstrap4.Bootstrap4PageFactory;
import j2html.TagCreator;
import j2html.tags.ContainerTag;
import j2html.tags.DomContent;
import java.util.List;
import java.util.Optional;
import java.util.Set;
import javax.inject.Inject;

public class ManualChangelogHandler
extends BaseHandler {
    private static final String P_name = "name";
    private static final String P_action = "action";
    private static final String P_toEmail = "toEmail";
    private static final String P_comment = "comment";
    private static final String P_submitAction = "submitAction";
    @Inject
    private Bootstrap4PageFactory pageFactory;
    @Inject
    private ChangelogRecorder changelogRecorder;
    @Inject
    private DatarouterService datarouterService;
    @Inject
    private DatarouterHtmlEmailService htmlEmailService;
    @Inject
    private DatarouterProperties datarouterProperties;
    @Inject
    private DatarouterAdministratorEmailService additionalAdministratorEmailService;
    @Inject
    private DatarouterChangelogPaths paths;

    @BaseHandler.Handler(defaultHandler=true)
    private Mav defaultHandler(@Param(value="name") OptionalString name, @Param(value="action") OptionalString action, @Param(value="toEmail") OptionalString toEmail, @Param(value="comment") OptionalString comment, @Param(value="submitAction") OptionalString submitAction) {
        HtmlForm form = new HtmlForm().withMethod("post");
        form.addTextField().withDisplay("Name").withName(P_name).withPlaceholder("Xyz Migration").withValue((String)name.orElse(null));
        form.addTextField().withDisplay("Action").withName(P_action).withPlaceholder("Backfill").withValue((String)action.orElse(null));
        form.addTextField().withDisplay("Email To (csv)").withName(P_toEmail).withPlaceholder("a@something.com,b@something.com").withValue((String)toEmail.orElse(null));
        form.addTextField().withDisplay("Comment (Optional)").withName(P_comment).withPlaceholder("Migration for tables xyz").withValue((String)toEmail.orElse(null));
        form.addButton().withDisplay("Record & Email").withValue("anything");
        if (submitAction.isEmpty() || form.hasErrors()) {
            return this.pageFactory.startBuilder(this.request).withTitle("Manual Changelog").withContent(Html.makeContent(form)).buildMav();
        }
        String username = this.getSessionInfo().getRequiredSession().getUsername();
        this.changelogRecorder.record("ManualEntry", (String)name.get(), (String)action.get(), username, this.getSessionInfo().getRequiredSession().getUserToken(), (String)comment.orElse(null));
        this.sendEmail((String)name.get(), (String)action.get(), username, toEmail.getOptional(), comment.getOptional());
        return this.pageFactory.preformattedMessage(this.request, "Recorded changelog entry.");
    }

    private void sendEmail(String name, String action, String username, Optional<String> toEmail, Optional<String> comment) {
        String from = this.datarouterProperties.getAdministratorEmail();
        String to = toEmail.map(email -> email.split(",")).map(stringArray -> Set.of(stringArray)).map(emailSet -> this.additionalAdministratorEmailService.getAdministratorEmailAddressesCsv(emailSet)).orElseGet(() -> this.additionalAdministratorEmailService.getAdministratorEmailAddressesCsv());
        String primaryHref = this.htmlEmailService.startLinkBuilder().withLocalPath(this.paths.datarouter.changelog.view).build();
        J2HtmlDatarouterEmailBuilder emailBuilder = this.htmlEmailService.startEmailBuilder().withSubject("Manual Changelog Entry - " + this.datarouterService.getName()).withTitle("Manual Changelog Entry").withTitleHref(primaryHref).withContent(this.makeEmailContent(name, action, username, comment.orElse("")));
        this.htmlEmailService.trySendJ2Html(from, to, emailBuilder);
    }

    private ContainerTag makeEmailContent(String name, String action, String username, String comment) {
        List<Twin> rows = List.of(new Twin((Object)"Service", (Object)this.datarouterService.getName()), new Twin((Object)"ChangelogType", (Object)"ManualEntry"), new Twin((Object)"Name", (Object)name), new Twin((Object)"Action", (Object)action), new Twin((Object)"Username", (Object)username), new Twin((Object)"Comment", (Object)comment));
        return new J2HtmlEmailTable().withColumn(new J2HtmlEmailTable.J2HtmlEmailTableColumn(null, row -> ManualChangelogHandler.makeDivBoldRight((String)row.getLeft()))).withColumn(new J2HtmlEmailTable.J2HtmlEmailTableColumn(null, row -> TagCreator.text((String)((String)row.getRight())))).build(rows);
    }

    private static DomContent makeDivBoldRight(String text) {
        return TagCreator.div((String)text).withStyle("font-weight:bold;text-align:right;");
    }

    private static class Html {
        private Html() {
        }

        public static ContainerTag makeContent(HtmlForm htmlForm) {
            ContainerTag form = (ContainerTag)Bootstrap4FormHtml.render((HtmlForm)htmlForm).withClass("card card-body bg-light");
            return (ContainerTag)TagCreator.div((DomContent[])new DomContent[]{TagCreator.h2((String)"Manual Changelog Recorder"), form, TagCreator.br()}).withClass("container mt-3");
        }
    }
}

