/*
 * Decompiled with CFR 0.152.
 */
package io.datarouter.changelog.service;

import io.datarouter.changelog.config.DatarouterChangelogSettingRoot;
import io.datarouter.changelog.storage.Changelog;
import io.datarouter.changelog.storage.ChangelogDao;
import io.datarouter.httpclient.client.DatarouterService;
import io.datarouter.instrumentation.changelog.ChangelogDto;
import io.datarouter.instrumentation.changelog.ChangelogPublisher;
import io.datarouter.instrumentation.changelog.ChangelogRecorder;
import java.util.Date;
import javax.inject.Inject;
import javax.inject.Singleton;

@Singleton
public class ChangeLogRecorderService
implements ChangelogRecorder {
    @Inject
    private ChangelogPublisher publisher;
    @Inject
    private DatarouterService datarouterService;
    @Inject
    private DatarouterChangelogSettingRoot settings;
    @Inject
    private ChangelogDao dao;

    public void record(String changelogType, String name, String action, String username, String userToken, String comment) {
        ChangelogDto dto = new ChangelogDto(this.datarouterService.getName(), changelogType, name, new Date().getTime(), action, username, userToken, comment);
        if (((Boolean)this.settings.publishChangelog.get()).booleanValue()) {
            this.publisher.add(dto);
        }
        this.dao.put(new Changelog(dto));
    }
}

