/*
 * Decompiled with CFR 0.152.
 */
package io.datarouter.changelog.service;

import io.datarouter.changelog.config.DatarouterChangelogPaths;
import io.datarouter.changelog.service.ViewChangelogService;
import io.datarouter.changelog.storage.Changelog;
import io.datarouter.changelog.storage.ChangelogDao;
import io.datarouter.changelog.storage.ChangelogKey;
import io.datarouter.email.html.J2HtmlEmailTable;
import io.datarouter.types.MilliTime;
import io.datarouter.types.MilliTimeReversed;
import io.datarouter.util.tuple.Range;
import io.datarouter.web.digest.DailyDigest;
import io.datarouter.web.digest.DailyDigestGrouping;
import io.datarouter.web.digest.DailyDigestService;
import j2html.TagCreator;
import j2html.tags.DomContent;
import j2html.tags.specialized.DivTag;
import j2html.tags.specialized.H3Tag;
import j2html.tags.specialized.SmallTag;
import j2html.tags.specialized.TableTag;
import jakarta.inject.Inject;
import jakarta.inject.Singleton;
import java.time.ZoneId;
import java.util.List;
import java.util.Optional;

@Singleton
public class ChangelogDailyDigest
implements DailyDigest {
    @Inject
    private ChangelogDao dao;
    @Inject
    private DailyDigestService digestService;
    @Inject
    private DatarouterChangelogPaths paths;
    @Inject
    private ViewChangelogService viewChangelogService;

    public Optional<DivTag> getPageContent(ZoneId zoneId) {
        List<Changelog> list = this.getChangelogs(zoneId);
        if (list.size() == 0) {
            return Optional.empty();
        }
        H3Tag header = this.digestService.makeHeader("Changelog", this.paths.datarouter.changelog.viewAll);
        SmallTag description = TagCreator.small((String)"For the current day");
        TableTag table = this.viewChangelogService.buildTable(list, zoneId);
        return Optional.of(TagCreator.div((DomContent[])new DomContent[]{header, description, table}));
    }

    public Optional<DivTag> getEmailContent(ZoneId zoneId) {
        List<Changelog> list = this.getChangelogs(zoneId);
        if (list.size() == 0) {
            return Optional.empty();
        }
        H3Tag header = this.digestService.makeHeader("Changelog", this.paths.datarouter.changelog.viewAll);
        SmallTag description = TagCreator.small((String)"For the current day");
        TableTag table = this.buildEmailTable(list, zoneId);
        return Optional.of(TagCreator.div((DomContent[])new DomContent[]{header, description, table}));
    }

    public String getTitle() {
        return "Changelog";
    }

    public DailyDigestGrouping getGrouping() {
        return DailyDigestGrouping.LOW;
    }

    public DailyDigest.DailyDigestType getType() {
        return DailyDigest.DailyDigestType.SUMMARY;
    }

    private List<Changelog> getChangelogs(ZoneId zoneId) {
        MilliTimeReversed startTime = MilliTime.atEndOfDay((ZoneId)zoneId).toMilliTimeReversed();
        MilliTimeReversed endTime = MilliTime.atStartOfDay((ZoneId)zoneId).toMilliTimeReversed();
        ChangelogKey start = new ChangelogKey(startTime, null, null);
        ChangelogKey stop = new ChangelogKey(endTime, null, null);
        Range range = new Range((Object)start, true, (Object)stop, true);
        return this.dao.scan((Range<ChangelogKey>)range).list();
    }

    private TableTag buildEmailTable(List<Changelog> rows, ZoneId zoneId) {
        return new J2HtmlEmailTable().withColumn(new J2HtmlEmailTable.J2HtmlEmailTableColumn("", row -> {
            String href = String.valueOf(this.paths.datarouter.changelog.viewExact.toSlashedString()) + "?" + "reversedDateMs" + "=" + ((ChangelogKey)row.getKey()).getMilliTimeReversed() + "&" + "changelogType" + "=" + ((ChangelogKey)row.getKey()).getChangelogType() + "&" + "name" + "=" + ((ChangelogKey)row.getKey()).getName();
            return this.digestService.makeATagLink("#", href);
        })).withColumn("Date", row -> ((ChangelogKey)row.getKey()).getMilliTimeReversed().format(zoneId)).withColumn("Type", row -> ((ChangelogKey)row.getKey()).getChangelogType()).withColumn("Name", row -> ((ChangelogKey)row.getKey()).getName()).withColumn("Action", Changelog::getAction).withColumn("User", Changelog::getUsername).build(rows);
    }
}

