/*
 * Decompiled with CFR 0.152.
 */
package io.datarouter.changelog.web;

import io.datarouter.changelog.config.DatarouterChangelogPaths;
import io.datarouter.changelog.service.ViewChangelogService;
import io.datarouter.changelog.storage.Changelog;
import io.datarouter.changelog.storage.ChangelogDao;
import io.datarouter.changelog.storage.ChangelogKey;
import io.datarouter.changelog.web.ChangelogHtml;
import io.datarouter.instrumentation.changelog.ChangelogDto;
import io.datarouter.instrumentation.changelog.ChangelogRecorder;
import io.datarouter.pathnode.PathNode;
import io.datarouter.storage.config.properties.ServiceName;
import io.datarouter.util.time.ZonedDateFormatterTool;
import io.datarouter.web.handler.BaseHandler;
import io.datarouter.web.handler.mav.Mav;
import io.datarouter.web.handler.mav.imp.InContextRedirectMav;
import io.datarouter.web.handler.types.Param;
import io.datarouter.web.html.form.HtmlForm;
import io.datarouter.web.html.j2html.J2HtmlLegendTable;
import io.datarouter.web.html.j2html.bootstrap4.Bootstrap4FormHtml;
import io.datarouter.web.html.j2html.bootstrap4.Bootstrap4PageFactory;
import io.datarouter.web.user.session.CurrentUserSessionInfoService;
import j2html.TagCreator;
import j2html.tags.DomContent;
import j2html.tags.specialized.DivTag;
import j2html.tags.specialized.FormTag;
import jakarta.inject.Inject;
import java.time.ZoneId;
import java.util.Optional;
import javax.servlet.ServletRequest;

public class EditChangelogHandler
extends BaseHandler {
    public static final String P_reversedDateMs = "reversedDateMs";
    public static final String P_changelogType = "changelogType";
    public static final String P_name = "name";
    public static final String P_note = "note";
    private static final String P_submitAction = "submitAction";
    @Inject
    private ChangelogDao dao;
    @Inject
    private Bootstrap4PageFactory pageFactory;
    @Inject
    private CurrentUserSessionInfoService sessionInfoService;
    @Inject
    private ChangelogRecorder recorder;
    @Inject
    private ServiceName serviceName;
    @Inject
    private DatarouterChangelogPaths paths;
    @Inject
    private ViewChangelogService viewChangelogService;

    @BaseHandler.Handler(defaultHandler=true)
    public Mav edit(@Param(value="reversedDateMs") Long reversedDateMs, @Param(value="changelogType") String changelogType, @Param(value="name") String name, @Param(value="note") Optional<String> note, @Param(value="submitAction") Optional<String> submitAction) {
        ChangelogKey key = new ChangelogKey(reversedDateMs, changelogType, name);
        Changelog changelog = this.dao.get(key);
        DivTag table = new J2HtmlLegendTable().withClass("table table-sm border table-striped").withSingleRow(false).withEntry("Date", this.printDate(changelog)).withEntry("Changelog Type", ((ChangelogKey)changelog.getKey()).getChangelogType()).withEntry("Name", ((ChangelogKey)changelog.getKey()).getName()).withEntry("Action", changelog.getAction()).withEntry("Username", changelog.getUsername()).withEntry("Comment", Optional.ofNullable(changelog.getComment()).orElse("")).withEntry("Note", Optional.ofNullable(changelog.getNote()).orElse("")).build();
        HtmlForm form = new HtmlForm().withMethod("post");
        form.addTextAreaField().withDisplay("Note (Optional)").withName(P_note).withPlaceholder(Optional.ofNullable(changelog.getNote()).orElse("")).withValue((String)note.orElse(null));
        form.addButton().withDisplay("update").withValue("anything");
        if (submitAction.isEmpty() || form.hasErrors()) {
            return this.pageFactory.startBuilder(this.request).withTitle("Manual Changelog").withContent((DomContent)Html.makeContent(this.paths.datarouter.changelog.edit, table, form)).buildMav();
        }
        note.ifPresent(newNote -> {
            changelog.setNote((String)newNote);
            ChangelogDto dto = changelog.toDto(this.serviceName.get());
            this.recorder.update(dto);
        });
        String href = this.viewChangelogService.buildViewExactHref(changelog, false);
        return new InContextRedirectMav(this.request, href);
    }

    private String printDate(Changelog row) {
        ZoneId zoneId = this.sessionInfoService.getZoneId((ServletRequest)this.request);
        long reversedDateMs = ((ChangelogKey)row.getKey()).getReversedDateMs();
        return ZonedDateFormatterTool.formatReversedLongMsWithZone((long)reversedDateMs, (ZoneId)zoneId);
    }

    private static class Html {
        private Html() {
        }

        public static DivTag makeContent(PathNode currentPath, DivTag table, HtmlForm htmlForm) {
            DivTag header = ChangelogHtml.makeHeader(currentPath);
            FormTag form = (FormTag)Bootstrap4FormHtml.render((HtmlForm)htmlForm).withClass("card card-body bg-light");
            DivTag container = (DivTag)TagCreator.div((DomContent[])new DomContent[]{TagCreator.h4((String)"Edit Changelog Note"), table, form}).withClass("container");
            return (DivTag)TagCreator.div((DomContent[])new DomContent[]{header, TagCreator.br(), container, TagCreator.br()}).withClass("container-fluid");
        }
    }
}

