/*
 * Decompiled with CFR 0.152.
 */
package io.datarouter.changelog.web;

import io.datarouter.changelog.config.DatarouterChangelogPaths;
import io.datarouter.changelog.service.ViewChangelogService;
import io.datarouter.changelog.storage.Changelog;
import io.datarouter.changelog.storage.ChangelogDao;
import io.datarouter.changelog.web.ChangelogHtml;
import io.datarouter.web.handler.BaseHandler;
import io.datarouter.web.handler.mav.Mav;
import io.datarouter.web.html.j2html.bootstrap4.Bootstrap4PageFactory;
import io.datarouter.web.html.pager.Bootstrap4PagerHtml;
import io.datarouter.web.html.pager.MemoryPager;
import io.datarouter.web.html.pager.MemorySorter;
import io.datarouter.web.user.session.CurrentUserSessionInfoService;
import j2html.TagCreator;
import j2html.tags.DomContent;
import j2html.tags.specialized.DivTag;
import j2html.tags.specialized.TableTag;
import java.util.Collections;
import java.util.HashMap;
import javax.inject.Inject;
import javax.servlet.ServletRequest;

public class ViewChangelogHandler
extends BaseHandler {
    @Inject
    private Bootstrap4PageFactory pageFactory;
    @Inject
    private ChangelogDao dao;
    @Inject
    private DatarouterChangelogPaths paths;
    @Inject
    private ViewChangelogService service;
    @Inject
    private CurrentUserSessionInfoService currentSessionInfoService;

    @BaseHandler.Handler(defaultHandler=true)
    public Mav viewAll() {
        MemoryPager pager = new MemoryPager(Collections.emptyList(), new MemorySorter(), String.valueOf(this.request.getContextPath()) + this.paths.datarouter.changelog.viewAll.toSlashedString(), new HashMap(), this.params, 100);
        MemoryPager.Page page = pager.collect(this.dao.scan());
        return this.pageFactory.startBuilder(this.request).withTitle("Changelog").withContent((DomContent)this.makeContent((MemoryPager.Page<Changelog>)page)).buildMav();
    }

    private DivTag makeContent(MemoryPager.Page<Changelog> page) {
        DivTag header = ChangelogHtml.makeHeader(this.paths.datarouter.changelog.viewAll);
        DivTag form = (DivTag)Bootstrap4PagerHtml.renderForm(page).withClass("mt-4");
        DivTag linkBar = (DivTag)Bootstrap4PagerHtml.renderLinkBar(page).withClass("mt-2");
        TableTag table = this.service.buildTable(page.rows, this.currentSessionInfoService.getZoneId((ServletRequest)this.request));
        return (DivTag)TagCreator.div((DomContent[])new DomContent[]{header, form, linkBar, table}).withClass("container-fluid");
    }
}

