/*
 * Decompiled with CFR 0.152.
 */
package io.datarouter.changelog.web;

import io.datarouter.changelog.config.DatarouterChangelogPaths;
import io.datarouter.changelog.service.ViewChangelogService;
import io.datarouter.changelog.storage.Changelog;
import io.datarouter.changelog.storage.ChangelogDao;
import io.datarouter.changelog.storage.ChangelogKey;
import io.datarouter.changelog.web.ChangelogHtml;
import io.datarouter.scanner.Scanner;
import io.datarouter.util.tuple.Range;
import io.datarouter.web.handler.BaseHandler;
import io.datarouter.web.handler.mav.Mav;
import io.datarouter.web.handler.types.Param;
import io.datarouter.web.html.form.HtmlForm;
import io.datarouter.web.html.j2html.bootstrap4.Bootstrap4FormHtml;
import io.datarouter.web.html.j2html.bootstrap4.Bootstrap4PageFactory;
import io.datarouter.web.user.session.CurrentUserSessionInfoService;
import j2html.TagCreator;
import j2html.tags.DomContent;
import j2html.tags.specialized.DivTag;
import j2html.tags.specialized.FormTag;
import j2html.tags.specialized.TableTag;
import java.text.ParseException;
import java.time.Duration;
import java.util.List;
import java.util.Optional;
import javax.inject.Inject;
import javax.servlet.ServletRequest;

public class ViewChangelogForDateRangeHandler
extends BaseHandler {
    private static final String P_reversedDateMs_exact = "dateExact";
    private static final String P_reversedDateMs_start = "dateStart";
    private static final String P_reversedDateMs_end = "dateEnd";
    @Inject
    private Bootstrap4PageFactory pageFactory;
    @Inject
    private ChangelogDao dao;
    @Inject
    private DatarouterChangelogPaths paths;
    @Inject
    private ViewChangelogService service;
    @Inject
    private CurrentUserSessionInfoService currentSessionInfoService;

    @BaseHandler.Handler(defaultHandler=true)
    public Mav viewForDateRange(@Param(value="dateExact") Optional<String> dateExact, @Param(value="dateStart") Optional<String> dateStart, @Param(value="dateEnd") Optional<String> dateEnd) {
        Optional<Range<ChangelogKey>> range;
        HtmlForm formExact = new HtmlForm();
        formExact.addDateField().withDisplay("Exact Date").withName(P_reversedDateMs_exact).withValue((String)dateExact.orElse(null)).isRequired();
        formExact.addButton().withDisplay("Search").withValue("anything");
        formExact.withAction(String.valueOf(this.servletContext.getContextPath()) + this.paths.datarouter.changelog.viewForDateRange.toSlashedString());
        HtmlForm formRange = new HtmlForm();
        formRange.addDateField().withDisplay("Date Start").withName(P_reversedDateMs_start).withValue((String)dateStart.orElse(null)).isRequired();
        formRange.addDateField().withDisplay("Date End").withName(P_reversedDateMs_end).withValue((String)dateEnd.orElse(null)).isRequired();
        formRange.addButton().withDisplay("Search").withValue("anything");
        formRange.withAction(String.valueOf(this.servletContext.getContextPath()) + this.paths.datarouter.changelog.viewForDateRange.toSlashedString());
        FormTag formExactTag = Bootstrap4FormHtml.render((HtmlForm)formExact, (boolean)true);
        FormTag formRangeTag = Bootstrap4FormHtml.render((HtmlForm)formRange, (boolean)true);
        Scanner<Changelog> scanner = Scanner.empty();
        if (dateExact.isPresent() && dateStart.isEmpty() && dateEnd.isEmpty() && (range = this.makeRange(dateExact.get())).isPresent()) {
            scanner = this.dao.scan(range.get());
        }
        if (dateExact.isEmpty() && dateStart.isPresent() && dateEnd.isPresent() && (range = this.makeRange(dateStart.get(), dateEnd.get())).isPresent()) {
            scanner = this.dao.scan(range.get());
        }
        return this.pageFactory.startBuilder(this.request).withTitle("Changelog").withContent((DomContent)this.makeContent(formExactTag, formRangeTag, scanner.list())).buildMav();
    }

    private DivTag makeContent(FormTag formExact, FormTag formRange, List<Changelog> rows) {
        DivTag header = ChangelogHtml.makeHeader(this.paths.datarouter.changelog.viewForDateRange);
        TableTag table = this.service.buildTable(rows, this.currentSessionInfoService.getZoneId((ServletRequest)this.request));
        return (DivTag)TagCreator.div((DomContent[])new DomContent[]{header, TagCreator.br(), formExact, TagCreator.h5((String)"or"), formRange, table}).withClass("container-fluid");
    }

    private Optional<Range<ChangelogKey>> makeRange(String dateExact) {
        long dateStartMs;
        if (dateExact.isEmpty()) {
            return Optional.empty();
        }
        try {
            dateStartMs = Bootstrap4FormHtml.DATE_FORMAT.parse(dateExact).getTime();
        }
        catch (ParseException e) {
            return Optional.empty();
        }
        long dateEndMs = dateStartMs + Duration.ofDays(1L).toMillis();
        return Optional.of(this.makeRangeInternal(dateStartMs, dateEndMs));
    }

    private Optional<Range<ChangelogKey>> makeRange(String dateStart, String dateEnd) {
        long dateEndMs;
        long dateStartMs;
        if (dateStart.isEmpty() || dateEnd.isEmpty()) {
            return Optional.empty();
        }
        try {
            dateStartMs = Bootstrap4FormHtml.DATE_FORMAT.parse(dateStart).getTime();
            dateEndMs = Bootstrap4FormHtml.DATE_FORMAT.parse(dateEnd).getTime();
        }
        catch (ParseException e) {
            return Optional.empty();
        }
        return Optional.of(this.makeRangeInternal(dateStartMs, dateEndMs));
    }

    private Range<ChangelogKey> makeRangeInternal(long dateStartMs, long dateEndMs) {
        long reversedateMsStart = Long.MAX_VALUE - dateStartMs;
        long reversedateMsEnd = Long.MAX_VALUE - dateEndMs;
        ChangelogKey start = new ChangelogKey(reversedateMsStart, null, null);
        ChangelogKey stop = new ChangelogKey(reversedateMsEnd, null, null);
        return new Range((Object)stop, true, (Object)start, true);
    }
}

