/*
 * Decompiled with CFR 0.152.
 */
package io.datarouter.changelog.web;

import io.datarouter.changelog.config.DatarouterChangelogPaths;
import io.datarouter.changelog.web.ChangelogHtml;
import io.datarouter.instrumentation.changelog.ChangelogRecorder;
import io.datarouter.pathnode.PathNode;
import io.datarouter.scanner.Scanner;
import io.datarouter.web.handler.BaseHandler;
import io.datarouter.web.handler.mav.Mav;
import io.datarouter.web.handler.types.Param;
import io.datarouter.web.html.form.HtmlForm;
import io.datarouter.web.html.j2html.bootstrap4.Bootstrap4FormHtml;
import io.datarouter.web.html.j2html.bootstrap4.Bootstrap4PageFactory;
import j2html.TagCreator;
import j2html.tags.DomContent;
import j2html.tags.specialized.DivTag;
import j2html.tags.specialized.FormTag;
import java.util.Optional;
import javax.inject.Inject;

public class ManualChangelogHandler
extends BaseHandler {
    private static final String P_name = "name";
    private static final String P_action = "action";
    private static final String P_toEmail = "toEmail";
    private static final String P_note = "note";
    private static final String P_submitAction = "submitAction";
    @Inject
    private Bootstrap4PageFactory pageFactory;
    @Inject
    private ChangelogRecorder changelogRecorder;
    @Inject
    private DatarouterChangelogPaths paths;

    @BaseHandler.Handler(defaultHandler=true)
    public Mav insert(@Param(value="name") Optional<String> name, @Param(value="action") Optional<String> action, @Param(value="toEmail") Optional<String> toEmail, @Param(value="note") Optional<String> note, @Param(value="submitAction") Optional<String> submitAction) {
        HtmlForm form = new HtmlForm().withMethod("post");
        form.addTextField().withDisplay("Name").withName(P_name).withPlaceholder("Xyz Migration").withValue((String)name.orElse(null));
        form.addTextField().withDisplay("Action").withName(P_action).withPlaceholder("Backfill").withValue((String)action.orElse(null));
        form.addTextField().withDisplay("Email To (csv) (Optional). All administrators are included by default").withName(P_toEmail).withPlaceholder("a@something.com,b@something.com").withValue((String)toEmail.orElse(null));
        form.addTextAreaField().withDisplay("Note (Optional)").withName(P_note).withPlaceholder("Migration for tables xyz").withValue((String)note.orElse(null));
        form.addButton().withDisplay("Record & Email").withValue("anything");
        if (submitAction.isEmpty() || form.hasErrors()) {
            return this.pageFactory.startBuilder(this.request).withTitle("Manual Changelog").withContent((DomContent)Html.makeContent(this.paths.datarouter.changelog.insert, form)).buildMav();
        }
        String username = this.getSessionInfo().getRequiredSession().getUsername();
        ChangelogRecorder.DatarouterChangelogDtoBuilder dto = new ChangelogRecorder.DatarouterChangelogDtoBuilder("ManualEntry", name.get(), action.get(), username);
        note.ifPresent(arg_0 -> ((ChangelogRecorder.DatarouterChangelogDtoBuilder)dto).withNote(arg_0));
        if (toEmail.isPresent()) {
            Scanner.of((Object[])toEmail.get().split(",")).forEach(arg_0 -> ((ChangelogRecorder.DatarouterChangelogDtoBuilder)dto).additionalSendTos(arg_0));
        }
        dto.sendEmail();
        this.changelogRecorder.record(dto.build());
        return this.pageFactory.preformattedMessage(this.request, "Recorded changelog entry.");
    }

    private static class Html {
        private Html() {
        }

        public static DivTag makeContent(PathNode currentPath, HtmlForm htmlForm) {
            DivTag header = ChangelogHtml.makeHeader(currentPath);
            FormTag form = (FormTag)Bootstrap4FormHtml.render((HtmlForm)htmlForm).withClass("card card-body bg-light");
            DivTag formDiv = (DivTag)TagCreator.div((DomContent[])new DomContent[]{TagCreator.h4((String)"Insert a Changelog"), form}).withClass("container mt-3");
            return (DivTag)TagCreator.div((DomContent[])new DomContent[]{header, formDiv, TagCreator.br()}).withClass("container-fluid mt-3");
        }
    }
}

