/*
 * Decompiled with CFR 0.152.
 */
package io.datarouter.changelog.service;

import io.datarouter.changelog.config.DatarouterChangelogPaths;
import io.datarouter.changelog.storage.Changelog;
import io.datarouter.changelog.storage.ChangelogKey;
import io.datarouter.util.number.RandomTool;
import io.datarouter.util.time.ZonedDateFormatterTool;
import io.datarouter.web.config.ServletContextSupplier;
import io.datarouter.web.html.j2html.J2HtmlTable;
import j2html.TagCreator;
import j2html.tags.DomContent;
import j2html.tags.specialized.ATag;
import j2html.tags.specialized.ButtonTag;
import j2html.tags.specialized.DivTag;
import j2html.tags.specialized.TableTag;
import j2html.tags.specialized.TdTag;
import java.time.ZoneId;
import java.util.List;
import javax.inject.Inject;
import javax.inject.Singleton;
import javax.servlet.ServletContext;
import org.apache.http.client.utils.URIBuilder;

@Singleton
public class ViewChangelogService {
    @Inject
    private ServletContextSupplier servletContext;
    @Inject
    private DatarouterChangelogPaths paths;

    public TableTag buildTable(List<Changelog> rows, ZoneId zoneId) {
        return new J2HtmlTable().withClasses(new String[]{"table table-sm table-striped my-4 border"}).withHtmlColumn("", row -> TagCreator.td((DomContent[])new DomContent[]{((ATag)TagCreator.a().withClass("fa fa-link")).withHref(this.buildViewExactHref((Changelog)((Object)row), true))})).withColumn("Date", row -> {
            long reversedDateMs = ((ChangelogKey)row.getKey()).getReversedDateMs();
            return ZonedDateFormatterTool.formatReversedLongMsWithZone((long)reversedDateMs, (ZoneId)zoneId);
        }).withColumn("Type", row -> ((ChangelogKey)row.getKey()).getChangelogType()).withColumn("Name", row -> ((ChangelogKey)row.getKey()).getName()).withColumn("Action", Changelog::getAction).withColumn("User", Changelog::getUsername).withHtmlColumn("Comment", row -> {
            String id = "" + ((ChangelogKey)row.getKey()).getReversedDateMs() + RandomTool.nextPositiveInt();
            return this.makeModal(id, row.getComment(), "comment");
        }).withHtmlColumn("Note", row -> {
            String id = "" + ((ChangelogKey)row.getKey()).getReversedDateMs() + RandomTool.nextPositiveInt();
            return this.makeModal(id, row.getNote(), "note");
        }).withHtmlColumn("Edit", row -> TagCreator.td((DomContent[])new DomContent[]{((ATag)TagCreator.a().withClass("fa fa-edit")).withHref(this.buildEditHref((Changelog)((Object)row)))})).build(rows);
    }

    public TdTag makeModal(String id, String comment, String type) {
        if (comment == null) {
            return TagCreator.td();
        }
        String modalId = String.valueOf(type) + "Modal" + id;
        ATag commentButton = (ATag)((ATag)((ATag)((ATag)TagCreator.a().withClass("fa fa-sticky-note")).attr("data-toggle", (Object)"modal")).attr("data-target", (Object)("#" + modalId))).withHref("#" + modalId);
        DivTag modalBody = (DivTag)((DivTag)TagCreator.div((String)comment).withClass("modal-body")).withStyle("text-align:left");
        DivTag modalFooter = (DivTag)TagCreator.div((DomContent[])new DomContent[]{((ButtonTag)((ButtonTag)TagCreator.button((String)"Close").withType("button")).withClass("btn btn-secondary")).attr("data-dismiss", (Object)"modal")}).withClass("modal-footer");
        DivTag modalContent = (DivTag)TagCreator.div((DomContent[])new DomContent[]{modalBody, modalFooter}).withClass("modal-content");
        DivTag modalDialog = (DivTag)((DivTag)TagCreator.div((DomContent[])new DomContent[]{modalContent}).withClass("modal-dialog")).attr("role", (Object)"document");
        DivTag modal = (DivTag)((DivTag)((DivTag)((DivTag)TagCreator.div((DomContent[])new DomContent[]{modalDialog}).withClass("modal fade")).withId(modalId)).attr("tabindex", (Object)"-1")).attr("role", (Object)"dialog");
        return (TdTag)TagCreator.td((DomContent[])new DomContent[]{TagCreator.div((DomContent[])new DomContent[]{commentButton, modal})}).withStyle("text-align:center");
    }

    public String buildViewExactHref(Changelog log, boolean withContext) {
        ChangelogKey key = (ChangelogKey)log.getKey();
        String path = this.paths.datarouter.changelog.viewExact.toSlashedString();
        if (withContext) {
            path = String.valueOf(((ServletContext)this.servletContext.get()).getContextPath()) + path;
        }
        return new URIBuilder().setPath(path).addParameter("reversedDateMs", key.getReversedDateMs().toString()).addParameter("changelogType", key.getChangelogType()).addParameter("name", key.getName()).toString();
    }

    public String buildEditHref(Changelog log) {
        ChangelogKey key = (ChangelogKey)log.getKey();
        return new URIBuilder().setPath(String.valueOf(((ServletContext)this.servletContext.get()).getContextPath()) + this.paths.datarouter.changelog.edit.toSlashedString()).addParameter("reversedDateMs", key.getReversedDateMs().toString()).addParameter("changelogType", key.getChangelogType()).addParameter("name", key.getName()).toString();
    }
}

