/*
 * Decompiled with CFR 0.152.
 */
package io.datarouter.changelog.service;

import io.datarouter.changelog.config.DatarouterChangelogSettingRoot;
import io.datarouter.changelog.service.ChangelogEmailService;
import io.datarouter.changelog.storage.Changelog;
import io.datarouter.changelog.storage.ChangelogDao;
import io.datarouter.instrumentation.changelog.ChangelogDto;
import io.datarouter.instrumentation.changelog.ChangelogPublisher;
import io.datarouter.instrumentation.changelog.ChangelogRecorder;
import io.datarouter.storage.config.properties.ServiceName;
import java.time.Instant;
import javax.inject.Inject;
import javax.inject.Singleton;

@Singleton
public class ChangelogRecorderService
implements ChangelogRecorder {
    @Inject
    private ChangelogPublisher publisher;
    @Inject
    private ServiceName serviceName;
    @Inject
    private DatarouterChangelogSettingRoot settings;
    @Inject
    private ChangelogDao dao;
    @Inject
    private ChangelogEmailService emailService;

    public void record(ChangelogRecorder.DatarouterChangelogDto changelogDto) {
        ChangelogDto dto = new ChangelogDto(this.serviceName.get(), changelogDto.changelogType, changelogDto.name, Instant.now().toEpochMilli(), changelogDto.action, changelogDto.username, (String)changelogDto.comment.orElse(null), (String)changelogDto.note.orElse(null));
        if (((Boolean)this.settings.publishChangelog.get()).booleanValue()) {
            this.publisher.add(dto);
        }
        this.dao.put(new Changelog(dto));
        if (changelogDto.sendEmail) {
            this.emailService.sendEmail(changelogDto);
        }
    }

    public void update(ChangelogDto changelogDto) {
        if (((Boolean)this.settings.publishChangelog.get()).booleanValue()) {
            this.publisher.add(changelogDto);
        }
        this.dao.put(new Changelog(changelogDto));
    }
}

