/*
 * Decompiled with CFR 0.152.
 */
package io.datarouter.changelog.service;

import io.datarouter.changelog.config.DatarouterChangelogPaths;
import io.datarouter.email.html.J2HtmlDatarouterEmailBuilder;
import io.datarouter.email.html.J2HtmlEmailTable;
import io.datarouter.instrumentation.changelog.ChangelogRecorder;
import io.datarouter.storage.config.properties.ServerName;
import io.datarouter.storage.config.properties.ServiceName;
import io.datarouter.web.email.DatarouterHtmlEmailService;
import j2html.TagCreator;
import j2html.tags.DomContent;
import j2html.tags.specialized.TableTag;
import java.util.List;
import javax.inject.Inject;
import javax.inject.Singleton;

@Singleton
public class ChangelogEmailService {
    @Inject
    private ServiceName serviceName;
    @Inject
    private DatarouterHtmlEmailService htmlEmailService;
    @Inject
    private DatarouterChangelogPaths paths;
    @Inject
    private ServerName serverName;

    public void sendEmail(ChangelogRecorder.DatarouterChangelogDto dto) {
        String primaryHref = this.htmlEmailService.startLinkBuilder().withLocalPath(this.paths.datarouter.changelog.viewAll).build();
        J2HtmlDatarouterEmailBuilder emailBuilder = this.htmlEmailService.startEmailBuilder().withTitle("Changelog - " + dto.changelogType).withTitleHref(primaryHref).withContent((DomContent)this.makeEmailContent(dto.changelogType, dto.name, dto.action, dto.username, dto.comment.orElse(""), dto.note.orElse(""))).fromAdmin().toAdmin(dto.includeMainDatarouterAdmin).toSubscribers(dto.includeSubscribers).to(dto.username);
        this.htmlEmailService.trySendJ2Html(emailBuilder);
    }

    private TableTag makeEmailContent(String changelogType, String name, String action, String username, String comment, String note) {
        List<Row> rows = List.of(new Row("Service", this.serviceName.get()), new Row("ServerName", this.serverName.get()), new Row("ChangelogType", changelogType), new Row("Name", name), new Row("Action", action), new Row("Username", username), new Row("Comment", comment), new Row("Note", note));
        return new J2HtmlEmailTable().withColumn(new J2HtmlEmailTable.J2HtmlEmailTableColumn(null, row -> ChangelogEmailService.makeDivBoldRight(row.header()))).withColumn(new J2HtmlEmailTable.J2HtmlEmailTableColumn(null, row -> ChangelogEmailService.makeSpanWhiteSpacePre(row.content()))).build(rows);
    }

    private static DomContent makeDivBoldRight(String text) {
        return TagCreator.div((String)text).withStyle("font-weight:bold;text-align:right;");
    }

    private static DomContent makeSpanWhiteSpacePre(String text) {
        return TagCreator.span((String)text).withStyle("white-space:pre");
    }

    private record Row(String header, String content) {
    }
}

