/*
 * Decompiled with CFR 0.152.
 */
package io.datarouter.changelog.web;

import io.datarouter.changelog.service.ViewChangelogService;
import io.datarouter.changelog.storage.Changelog;
import io.datarouter.changelog.storage.ChangelogDao;
import io.datarouter.changelog.storage.ChangelogKey;
import io.datarouter.util.time.ZonedDateFormatterTool;
import io.datarouter.web.handler.BaseHandler;
import io.datarouter.web.handler.mav.Mav;
import io.datarouter.web.handler.mav.imp.MessageMav;
import io.datarouter.web.handler.types.Param;
import io.datarouter.web.html.j2html.J2HtmlLegendTable;
import io.datarouter.web.html.j2html.bootstrap4.Bootstrap4PageFactory;
import io.datarouter.web.user.session.CurrentUserSessionInfoService;
import j2html.TagCreator;
import j2html.tags.ContainerTag;
import j2html.tags.DomContent;
import j2html.tags.specialized.ATag;
import java.time.ZoneId;
import java.util.Date;
import java.util.Optional;
import javax.inject.Inject;
import javax.servlet.ServletRequest;

public class ViewExactChangelogHandler
extends BaseHandler {
    public static final String P_reversedDateMs = "reversedDateMs";
    public static final String P_changelogType = "changelogType";
    public static final String P_name = "name";
    @Inject
    private ChangelogDao dao;
    @Inject
    private Bootstrap4PageFactory pageFactory;
    @Inject
    private CurrentUserSessionInfoService sessionInfoService;
    @Inject
    private ViewChangelogService service;

    @BaseHandler.Handler(defaultHandler=true)
    public Mav viewExact(@Param(value="reversedDateMs") Long reversedDateMs, @Param(value="changelogType") String changelogType, @Param(value="name") String name) {
        ChangelogKey key = new ChangelogKey(reversedDateMs, changelogType, name);
        Optional<Changelog> changelog = this.dao.find(key);
        if (changelog.isEmpty()) {
            return new MessageMav("Unable to find changelog");
        }
        return this.pageFactory.startBuilder(this.request).withTitle("Changelog").withContent(this.makeContent(changelog.get())).buildMav();
    }

    private ContainerTag<?> makeContent(Changelog changelog) {
        ContainerTag table = new J2HtmlLegendTable().withClass("table table-sm border table-striped").withSingleRow(false).withEntry("Date", this.getDate(changelog)).withEntry("Changelog Type", ((ChangelogKey)changelog.getKey()).getChangelogType()).withEntry("Name", ((ChangelogKey)changelog.getKey()).getName()).withEntry("Action", changelog.getAction()).withEntry("Username", changelog.getUsername()).withEntry("Comment", Optional.ofNullable(changelog.getComment()).orElse("")).withEntry("Note", Optional.ofNullable(changelog.getNote()).orElse("")).build();
        ATag editButton = (ATag)((ATag)TagCreator.a((String)"Edit Note").withHref(this.service.buildEditHref(changelog))).withClass("btn btn-primary");
        return (ContainerTag)TagCreator.div((DomContent[])new DomContent[]{table, editButton}).withClass("container my-4");
    }

    private String getDate(Changelog row) {
        ZoneId zoneId = this.sessionInfoService.getZoneId((ServletRequest)this.request);
        Long reversedDateMs = ((ChangelogKey)row.getKey()).getReversedDateMs();
        Date date = new Date(Long.MAX_VALUE - reversedDateMs);
        return ZonedDateFormatterTool.formatDateWithZone((Date)date, (ZoneId)zoneId);
    }
}

