/*
 * Decompiled with CFR 0.152.
 */
package io.datarouter.bytes.binarydto.fieldcodec.other;

import io.datarouter.bytes.ByteTool;
import io.datarouter.bytes.LengthAndValue;
import io.datarouter.bytes.VarIntTool;
import io.datarouter.bytes.binarydto.fieldcodec.BinaryDtoBaseFieldCodec;
import io.datarouter.bytes.binarydto.internal.BinaryDtoNullFieldTool;
import java.util.ArrayList;
import java.util.List;

public class ListBinaryDtoFieldCodec<T>
extends BinaryDtoBaseFieldCodec<List<T>> {
    private final BinaryDtoBaseFieldCodec<T> itemCodec;
    private final boolean isNullableItems;

    public ListBinaryDtoFieldCodec(BinaryDtoBaseFieldCodec<T> itemCodec, boolean isNullableItems) {
        this.itemCodec = itemCodec;
        this.isNullableItems = isNullableItems;
    }

    @Override
    public byte[] encode(List<T> value) {
        int size = value.size();
        ArrayList<byte[]> byteArrays = new ArrayList<byte[]>(2 * size + 1);
        byte[] sizeBytes = VarIntTool.encode(size);
        byteArrays.add(sizeBytes);
        for (T item : value) {
            if (item == null) {
                if (this.isNullableItems) {
                    byteArrays.add(BinaryDtoNullFieldTool.NULL_INDICATOR_TRUE_ARRAY);
                    continue;
                }
                throw new IllegalArgumentException("Cannot contain nulls");
            }
            byteArrays.add(BinaryDtoNullFieldTool.NULL_INDICATOR_FALSE_ARRAY);
            byte[] itemBytes = this.itemCodec.encode(item);
            byteArrays.add(itemBytes);
        }
        return ByteTool.concat(byteArrays);
    }

    @Override
    public List<T> decode(byte[] bytes, int offset) {
        return (List)this.decodeWithLength((byte[])bytes, (int)offset).value;
    }

    @Override
    public LengthAndValue<List<T>> decodeWithLength(byte[] bytes, int offset) {
        int cursor = offset;
        int size = VarIntTool.decodeInt(bytes, cursor);
        cursor += VarIntTool.length(size);
        ArrayList value = new ArrayList(size);
        int i = 0;
        while (i < size) {
            boolean isItemNull = false;
            if (this.isNullableItems) {
                isItemNull = BinaryDtoNullFieldTool.decodeNullIndicator(bytes[cursor]);
                ++cursor;
            }
            if (isItemNull) {
                value.add(null);
            } else {
                LengthAndValue<T> lengthAndValue = this.itemCodec.decodeWithLength(bytes, cursor);
                cursor += lengthAndValue.length;
                value.add(lengthAndValue.value);
            }
            ++i;
        }
        int length = cursor - offset;
        return new LengthAndValue<List<T>>(length, value);
    }
}

