/*
 * Decompiled with CFR 0.152.
 */
package io.datarouter.bytes.binarydto.codec;

import io.datarouter.bytes.ByteTool;
import io.datarouter.bytes.VarIntTool;
import io.datarouter.bytes.binarydto.dto.BinaryDto;
import io.datarouter.bytes.binarydto.internal.BinaryDtoAllocator;
import io.datarouter.bytes.binarydto.internal.BinaryDtoFieldSchema;
import io.datarouter.bytes.binarydto.internal.BinaryDtoMetadataParser;
import io.datarouter.scanner.Scanner;
import java.lang.reflect.Field;
import java.util.ArrayList;
import java.util.List;
import java.util.Map;
import java.util.concurrent.ConcurrentHashMap;

public class BinaryDtoValueCodec<T extends BinaryDto<T>> {
    private static final Map<Class<? extends BinaryDto<?>>, BinaryDtoValueCodec<?>> CACHE = new ConcurrentHashMap();
    private static final int TOKENS_PER_FIELD = 3;
    public final Class<T> dtoClass;
    public final List<Field> fields;
    public final List<? extends BinaryDtoFieldSchema<?>> fieldSchemas;

    private BinaryDtoValueCodec(Class<T> dtoClass) {
        this.dtoClass = dtoClass;
        T dto = BinaryDtoAllocator.allocate(dtoClass);
        BinaryDtoMetadataParser<T> metadataParser = new BinaryDtoMetadataParser<T>(dto);
        this.fields = metadataParser.listFields();
        this.fieldSchemas = Scanner.of(this.fields).map(field -> {
            if (field == null) {
                return null;
            }
            field.setAccessible(true);
            BinaryDtoFieldSchema fieldSchema = new BinaryDtoFieldSchema((Field)field);
            return fieldSchema;
        }).list();
    }

    public static <T extends BinaryDto<T>> BinaryDtoValueCodec<T> of(Class<? extends T> dtoClass) {
        BinaryDtoValueCodec<Object> codec = CACHE.get(dtoClass);
        if (codec == null) {
            codec = new BinaryDtoValueCodec<T>(dtoClass);
            CACHE.put(dtoClass, codec);
        }
        return codec;
    }

    public List<Field> getFieldsOrdered() {
        return this.fields;
    }

    public byte[] encode(T dto) {
        ArrayList<byte[]> tokens = new ArrayList<byte[]>(3 * this.fieldSchemas.size());
        int i = 0;
        while (i < this.fieldSchemas.size()) {
            BinaryDtoFieldSchema<?> fieldSchema = this.fieldSchemas.get(i);
            if (fieldSchema != null && !fieldSchema.isNull(dto)) {
                byte[] fieldBytes = fieldSchema.encodeValue(dto);
                tokens.add(VarIntTool.encode(i));
                tokens.add(VarIntTool.encode(fieldBytes.length));
                tokens.add(fieldBytes);
            }
            ++i;
        }
        return ByteTool.concat(tokens);
    }
}

