/*
 * Decompiled with CFR 0.152.
 */
package io.datarouter.aws.sqs.single.op;

import com.amazonaws.AbortedException;
import com.amazonaws.services.sqs.model.SendMessageRequest;
import io.datarouter.aws.sqs.BaseSqsNode;
import io.datarouter.aws.sqs.SqsClientManager;
import io.datarouter.aws.sqs.SqsDataTooLargeException;
import io.datarouter.aws.sqs.op.SqsOp;
import io.datarouter.bytes.StringByteTool;
import io.datarouter.model.databean.Databean;
import io.datarouter.model.key.primary.PrimaryKey;
import io.datarouter.model.serialize.fielder.DatabeanFielder;
import io.datarouter.storage.client.ClientId;
import io.datarouter.storage.config.Config;
import io.datarouter.storage.serialize.fieldcache.FieldGeneratorTool;
import io.datarouter.storage.serialize.fieldcache.PhysicalDatabeanFieldInfo;
import io.datarouter.util.concurrent.UncheckedInterruptedException;
import java.util.List;

public class SqsPutOp<PK extends PrimaryKey<PK>, D extends Databean<PK, D>, F extends DatabeanFielder<PK, D>>
extends SqsOp<PK, D, F, Void> {
    private final D databean;
    private final SqsClientManager sqsClientManager;
    private final ClientId clientId;

    public SqsPutOp(D databean, Config config, BaseSqsNode<PK, D, F> sqsNode, SqsClientManager sqsClientManager, ClientId clientId) {
        super(config, sqsNode);
        this.databean = databean;
        this.sqsClientManager = sqsClientManager;
        this.clientId = clientId;
    }

    @Override
    protected Void run() {
        FieldGeneratorTool.generateAndSetValueForFieldIfNecessary((PhysicalDatabeanFieldInfo)this.fieldInfo, this.databean);
        String encodedDatabean = this.codec.toString(this.databean, this.fielder);
        if (StringByteTool.getUtf8Bytes((String)encodedDatabean).length > 262144) {
            throw new SqsDataTooLargeException(List.of(encodedDatabean));
        }
        SendMessageRequest request = new SendMessageRequest(this.queueUrl, encodedDatabean);
        try {
            this.sqsClientManager.getAmazonSqs(this.clientId).sendMessage(request);
        }
        catch (AbortedException e) {
            throw new UncheckedInterruptedException("", (Exception)((Object)e));
        }
        return null;
    }
}

