/*
 * Decompiled with CFR 0.152.
 */
package io.datarouter.aws.sqs;

import com.amazonaws.http.IdleConnectionReaper;
import com.amazonaws.services.sqs.AmazonSQS;
import com.amazonaws.services.sqs.model.QueueAttributeName;
import io.datarouter.aws.sqs.AmazonSqsHolder;
import io.datarouter.storage.client.BaseClientManager;
import io.datarouter.storage.client.ClientId;
import java.util.List;
import java.util.Map;
import javax.inject.Inject;
import javax.inject.Singleton;

@Singleton
public class SqsClientManager
extends BaseClientManager {
    @Inject
    private AmazonSqsHolder amazonSqsHolder;

    public void shutdown(ClientId clientId) {
        this.amazonSqsHolder.get(clientId).shutdown();
        IdleConnectionReaper.shutdown();
    }

    protected void safeInitClient(ClientId clientId) {
        this.amazonSqsHolder.registerClient(clientId);
    }

    public AmazonSQS getAmazonSqs(ClientId clientId) {
        this.initClient(clientId);
        return this.amazonSqsHolder.get(clientId);
    }

    public String getQueueAttribute(ClientId clientId, String queueUrl, QueueAttributeName attributeName) {
        return this.getQueueAttributes(clientId, queueUrl, List.of(attributeName.name())).get(attributeName.name());
    }

    public Map<String, String> getAllQueueAttributes(ClientId clientId, String sqsQueueUrl) {
        return this.getQueueAttributes(clientId, sqsQueueUrl, List.of(QueueAttributeName.All.name()));
    }

    public Map<String, String> getQueueAttributes(ClientId clientId, String queueUrl, List<String> attributes) {
        return this.getAmazonSqs(clientId).getQueueAttributes(queueUrl, attributes).getAttributes();
    }

    public void updateAttr(ClientId clientId, String queueUrl, QueueAttributeName key, Object value) {
        Map<String, String> attributes = Map.of(key.name(), String.valueOf(value));
        this.getAmazonSqs(clientId).setQueueAttributes(queueUrl, attributes);
    }
}

