/*
 * Decompiled with CFR 0.152.
 */
package io.datarouter.aws.sqs;

import com.amazonaws.services.sqs.model.CreateQueueRequest;
import com.amazonaws.services.sqs.model.QueueAttributeName;
import io.datarouter.aws.sqs.SqsClientManager;
import io.datarouter.aws.sqs.SqsClientType;
import io.datarouter.aws.sqs.SqsOpFactory;
import io.datarouter.model.databean.Databean;
import io.datarouter.model.key.primary.PrimaryKey;
import io.datarouter.model.serialize.fielder.DatabeanFielder;
import io.datarouter.storage.client.ClientId;
import io.datarouter.storage.client.ClientType;
import io.datarouter.storage.config.Config;
import io.datarouter.storage.config.properties.EnvironmentName;
import io.datarouter.storage.node.NodeParams;
import io.datarouter.storage.node.op.raw.write.QueueStorageWriter;
import io.datarouter.storage.node.type.physical.base.BasePhysicalNode;
import io.datarouter.storage.queue.QueueMessageKey;
import io.datarouter.util.singletonsupplier.SingletonSupplier;
import io.datarouter.util.string.StringTool;
import io.datarouter.util.tuple.Twin;
import io.datarouter.web.config.service.ServiceName;
import java.time.Duration;
import java.util.Collection;
import java.util.function.Supplier;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;

public abstract class BaseSqsNode<PK extends PrimaryKey<PK>, D extends Databean<PK, D>, F extends DatabeanFielder<PK, D>>
extends BasePhysicalNode<PK, D, F>
implements QueueStorageWriter<PK, D> {
    private static final Logger logger = LoggerFactory.getLogger(BaseSqsNode.class);
    public static final int MAX_MESSAGES_PER_BATCH = 10;
    public static final int MAX_TIMEOUT_SECONDS = 20;
    public static final int MAX_BYTES_PER_MESSAGE = 262144;
    public static final int MAX_BYTES_PER_PAYLOAD = 262144;
    public static final int MIN_QUEUE_NAME_LENGTH = 1;
    public static final int MAX_QUEUE_NAME_LENGTH = 80;
    public static final long DEFAULT_VISIBILITY_TIMEOUT_MS = Duration.ofSeconds(30L).toMillis();
    private static final long RETENTION_S = Duration.ofDays(14L).getSeconds();
    private final EnvironmentName environmentName;
    private final ServiceName serviceName;
    private final NodeParams<PK, D, F> params;
    private final Supplier<Twin<String>> queueUrlAndName;
    private final SqsClientManager sqsClientManager;
    private final ClientId clientId;
    protected final SqsOpFactory<PK, D, F> sqsOpFactory;
    private final boolean owned;

    public BaseSqsNode(EnvironmentName environmentName, ServiceName serviceName, NodeParams<PK, D, F> params, SqsClientType sqsClientType, SqsClientManager sqsClientManager, ClientId clientId) {
        super(params, (ClientType)sqsClientType);
        this.environmentName = environmentName;
        this.serviceName = serviceName;
        this.params = params;
        this.sqsClientManager = sqsClientManager;
        this.clientId = clientId;
        this.queueUrlAndName = SingletonSupplier.of(this::getOrCreateQueueUrl);
        this.sqsOpFactory = new SqsOpFactory(this, sqsClientManager, clientId);
        this.owned = params.getQueueUrl() == null;
    }

    private Twin<String> getOrCreateQueueUrl() {
        String queueName;
        String queueUrl;
        if (!this.owned) {
            queueUrl = this.params.getQueueUrl();
            queueName = queueUrl.substring(queueUrl.lastIndexOf(47) + 1);
        } else {
            queueName = this.buildQueueName(this.environmentName.get(), this.serviceName.get());
            queueUrl = this.createQueueAndGetUrl(queueName);
            this.sqsClientManager.updateAttr(this.clientId, queueUrl, QueueAttributeName.MessageRetentionPeriod, RETENTION_S);
            logger.warn("retention updated queueName=" + queueName);
        }
        logger.warn("nodeName={}, queueUrl={}", (Object)this.getName(), (Object)queueUrl);
        return new Twin((Object)queueUrl, (Object)queueName);
    }

    private String createQueueAndGetUrl(String queueName) {
        CreateQueueRequest createQueueRequest = new CreateQueueRequest(queueName);
        try {
            return this.sqsClientManager.getAmazonSqs(this.clientId).createQueue(createQueueRequest).getQueueUrl();
        }
        catch (RuntimeException e) {
            throw new RuntimeException("queueName=" + queueName + " queueNameLength=" + queueName.length(), e);
        }
    }

    private String getOrBuildNamespace(String environmentName, String serviceName) {
        return this.params.getNamespace().orElseGet(() -> this.buildNamespace(environmentName, serviceName));
    }

    private String buildNamespace(String environmentName, String serviceName) {
        return String.valueOf(environmentName) + "-" + serviceName;
    }

    public String buildNamespace() {
        return this.buildNamespace(this.environmentName.get(), this.serviceName.get());
    }

    public String buildQueueName(String environmentName, String serviceName) {
        String queueName;
        String namespace = this.getOrBuildNamespace(environmentName, serviceName);
        String tableName = this.getFieldInfo().getTableName();
        String string = queueName = StringTool.isEmpty((String)namespace) ? tableName : String.valueOf(namespace) + "-" + tableName;
        if (queueName.length() > 80) {
            logger.error("queue={} overflows the max size {}", (Object)queueName, (Object)80);
        }
        return queueName;
    }

    public Supplier<Twin<String>> getQueueUrlAndName() {
        return this.queueUrlAndName;
    }

    public boolean isOwned() {
        return this.owned;
    }

    public void ack(QueueMessageKey key, Config config) {
        this.sqsOpFactory.makeAckOp(key, config).call();
    }

    public void ackMulti(Collection<QueueMessageKey> keys, Config config) {
        this.sqsOpFactory.makeAckMultiOp(keys, config).call();
    }
}

