/*
 * Decompiled with CFR 0.152.
 */
package io.datarouter.aws.sqs.op;

import com.amazonaws.AbortedException;
import com.amazonaws.services.sqs.model.Message;
import com.amazonaws.services.sqs.model.ReceiveMessageRequest;
import com.amazonaws.services.sqs.model.ReceiveMessageResult;
import io.datarouter.aws.sqs.BaseSqsNode;
import io.datarouter.aws.sqs.SqsClientManager;
import io.datarouter.aws.sqs.op.SqsOp;
import io.datarouter.model.databean.Databean;
import io.datarouter.model.key.primary.PrimaryKey;
import io.datarouter.model.serialize.fielder.DatabeanFielder;
import io.datarouter.storage.client.ClientId;
import io.datarouter.storage.config.Config;
import io.datarouter.util.concurrent.UncheckedInterruptedException;
import java.time.Duration;
import java.util.List;

public abstract class BaseSqsPeekMultiOp<PK extends PrimaryKey<PK>, D extends Databean<PK, D>, F extends DatabeanFielder<PK, D>, T>
extends SqsOp<PK, D, F, List<T>> {
    private final SqsClientManager sqsClientManager;
    private final ClientId clientId;

    public BaseSqsPeekMultiOp(Config config, BaseSqsNode<PK, D, F> sqsNode, SqsClientManager sqsClientManager, ClientId clientId) {
        super(config, sqsNode);
        this.sqsClientManager = sqsClientManager;
        this.clientId = clientId;
    }

    @Override
    protected final List<T> run() {
        ReceiveMessageResult result;
        ReceiveMessageRequest request = this.makeRequest();
        try {
            result = this.sqsClientManager.getAmazonSqs(this.clientId).receiveMessage(request);
        }
        catch (AbortedException e) {
            throw new UncheckedInterruptedException("", (Exception)((Object)e));
        }
        List messages = result.getMessages();
        return messages.isEmpty() ? List.of() : this.extractDatabeans(messages);
    }

    protected abstract List<T> extractDatabeans(List<Message> var1);

    private ReceiveMessageRequest makeRequest() {
        ReceiveMessageRequest request = new ReceiveMessageRequest(this.queueUrl);
        Duration configTimeout = this.config.getTimeoutOrUse(Duration.ofMillis(Long.MAX_VALUE));
        long waitTimeMs = Math.min(configTimeout.toMillis(), 20000L);
        request.setWaitTimeSeconds(Integer.valueOf((int)Duration.ofMillis(waitTimeMs).getSeconds()));
        long visibilityTimeoutMs = this.config.getVisibilityTimeoutMsOrUse(BaseSqsNode.DEFAULT_VISIBILITY_TIMEOUT_MS);
        request.setVisibilityTimeout(Integer.valueOf((int)Duration.ofMillis(visibilityTimeoutMs).getSeconds()));
        request.setMaxNumberOfMessages(this.config.findLimit().orElse(10));
        return request;
    }
}

