/*
 * Decompiled with CFR 0.152.
 */
package io.datarouter.aws.sqs.job;

import com.amazonaws.services.sqs.model.QueueAttributeName;
import io.datarouter.aws.sqs.BaseSqsNode;
import io.datarouter.aws.sqs.SqsClientManager;
import io.datarouter.aws.sqs.SqsClientType;
import io.datarouter.aws.sqs.SqsMetrics;
import io.datarouter.instrumentation.task.TaskTracker;
import io.datarouter.job.BaseJob;
import io.datarouter.storage.client.ClientId;
import io.datarouter.storage.client.ClientInitializationTracker;
import io.datarouter.storage.client.DatarouterClients;
import io.datarouter.storage.node.DatarouterNodes;
import io.datarouter.storage.node.NodeTool;
import io.datarouter.util.tuple.Twin;
import java.util.Collection;
import javax.inject.Inject;

public class SqsQueuesLengthMonitoringJob
extends BaseJob {
    @Inject
    private DatarouterClients datarouterClients;
    @Inject
    private DatarouterNodes datarouterNodes;
    @Inject
    private SqsClientManager sqsClientManager;
    @Inject
    private ClientInitializationTracker clientInitializationTracker;
    @Inject
    private SqsMetrics metrics;

    public void run(TaskTracker tracker) {
        this.clientInitializationTracker.getInitializedClients().stream().filter(clientId -> this.datarouterClients.getClientTypeInstance(clientId) instanceof SqsClientType).map(ClientId::getName).map(arg_0 -> ((DatarouterNodes)this.datarouterNodes).getPhysicalNodesForClient(arg_0)).flatMap(Collection::stream).map(NodeTool::extractSinglePhysicalNode).map(physicalNode -> (BaseSqsNode)((Object)physicalNode)).forEach(this::getQueueLengthAndSaveAsMetric);
    }

    private void getQueueLengthAndSaveAsMetric(BaseSqsNode<?, ?, ?> baseSqsNode) {
        Twin<String> queueUrlAndName = baseSqsNode.getQueueUrlAndName().get();
        String queueName = (String)queueUrlAndName.getRight();
        ClientId clientId = baseSqsNode.getClientId();
        String queueUrl = (String)queueUrlAndName.getLeft();
        String queueLengthString = this.sqsClientManager.getQueueAttribute(clientId, queueUrl, QueueAttributeName.ApproximateNumberOfMessages);
        long queueLength = Long.parseLong(queueLengthString);
        this.metrics.saveSqsQueueLength(queueName, queueLength);
    }
}

