/*
 * Decompiled with CFR 0.152.
 */
package io.datarouter.aws.sqs;

import com.amazonaws.regions.Regions;
import io.datarouter.storage.client.ClientId;
import io.datarouter.storage.client.ClientOptions;
import io.datarouter.storage.client.ClientOptionsBuilder;
import java.util.Properties;

public class SqsClientOptionsBuilder
implements ClientOptionsBuilder {
    private final String clientIdName;
    private final Properties properties;

    public SqsClientOptionsBuilder(ClientId clientId) {
        this.clientIdName = clientId.getName();
        this.properties = new Properties();
        this.properties.setProperty(ClientOptions.makeClientTypeKey((String)this.clientIdName), "sqs");
    }

    public SqsClientOptionsBuilder withRegion(Regions region) {
        String optionKey = this.makeKey("region");
        this.properties.setProperty(optionKey, region.getName());
        return this;
    }

    public SqsClientOptionsBuilder withCredentialsLocation(String accessKeyLocation) {
        String optionKey = this.makeKey("credentials.location");
        this.properties.setProperty(optionKey, accessKeyLocation);
        return this;
    }

    public SqsClientOptionsBuilder withAccessKey(String accessKey) {
        String optionKey = this.makeKey("accessKey");
        this.properties.setProperty(optionKey, accessKey);
        return this;
    }

    public SqsClientOptionsBuilder withSecretKey(String secretKey) {
        String optionKey = this.makeKey("secretKey");
        this.properties.setProperty(optionKey, secretKey);
        return this;
    }

    public Properties build() {
        return this.properties;
    }

    private String makeKey(String suffix) {
        return ClientOptions.makeClientPrefixedKey((String)this.clientIdName, (String)suffix);
    }
}

