/*
 * Decompiled with CFR 0.152.
 */
package io.datarouter.aws.sqs;

import com.amazonaws.services.sqs.AmazonSQS;
import com.amazonaws.services.sqs.model.QueueAttributeName;
import io.datarouter.aws.sqs.AmazonSqsHolder;
import io.datarouter.storage.client.BaseClientManager;
import io.datarouter.storage.client.ClientId;
import java.util.Collections;
import java.util.List;
import java.util.Map;
import javax.inject.Inject;
import javax.inject.Singleton;

@Singleton
public class SqsClientManager
extends BaseClientManager {
    private static final List<String> ALL_ATTRIBUTE_AS_LIST = Collections.singletonList(QueueAttributeName.All.name());
    @Inject
    private AmazonSqsHolder amazonSqsHolder;

    public void shutdown(ClientId clientId) {
        this.amazonSqsHolder.get(clientId).shutdown();
    }

    protected void safeInitClient(ClientId clientId) {
        this.amazonSqsHolder.registerClient(clientId);
    }

    public AmazonSQS getAmazonSqs(ClientId clientId) {
        this.initClient(clientId);
        return this.amazonSqsHolder.get(clientId);
    }

    public Map<String, String> getQueueAttributes(ClientId clientId, String sqsQueueUrl, List<String> attributes) {
        return this.getAmazonSqs(clientId).getQueueAttributes(sqsQueueUrl, attributes).getAttributes();
    }

    public Map<String, String> getAllQueueAttributes(ClientId clientId, String sqsQueueUrl) {
        return this.getQueueAttributes(clientId, sqsQueueUrl, ALL_ATTRIBUTE_AS_LIST);
    }
}

