/*
 * Decompiled with CFR 0.152.
 */
package io.datarouter.aws.sqs;

import com.amazonaws.services.sqs.model.CreateQueueRequest;
import io.datarouter.aws.sqs.SqsClientManager;
import io.datarouter.aws.sqs.SqsClientType;
import io.datarouter.aws.sqs.SqsOpFactory;
import io.datarouter.httpclient.client.DatarouterService;
import io.datarouter.model.databean.Databean;
import io.datarouter.model.key.primary.PrimaryKey;
import io.datarouter.model.serialize.fielder.DatabeanFielder;
import io.datarouter.storage.client.ClientId;
import io.datarouter.storage.client.ClientType;
import io.datarouter.storage.config.Config;
import io.datarouter.storage.config.DatarouterProperties;
import io.datarouter.storage.node.NodeParams;
import io.datarouter.storage.node.op.raw.write.QueueStorageWriter;
import io.datarouter.storage.node.type.physical.base.BasePhysicalNode;
import io.datarouter.storage.queue.QueueMessageKey;
import io.datarouter.util.lazy.Lazy;
import io.datarouter.util.string.StringTool;
import java.time.Duration;
import java.util.Collection;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;

public abstract class BaseSqsNode<PK extends PrimaryKey<PK>, D extends Databean<PK, D>, F extends DatabeanFielder<PK, D>>
extends BasePhysicalNode<PK, D, F>
implements QueueStorageWriter<PK, D> {
    private static final Logger logger = LoggerFactory.getLogger(BaseSqsNode.class);
    public static final int MAX_MESSAGES_PER_BATCH = 10;
    public static final int MAX_TIMEOUT_SECONDS = 20;
    public static final int MAX_BYTES_PER_MESSAGE = 262144;
    public static final int MAX_BYTES_PER_PAYLOAD = 262144;
    public static final long DEFAULT_VISIBILITY_TIMEOUT_MS = Duration.ofSeconds(30L).toMillis();
    private final DatarouterProperties datarouterProperties;
    private final DatarouterService datarouterService;
    private final NodeParams<PK, D, F> params;
    private final Lazy<String> queueUrl;
    private final SqsClientManager sqsClientManager;
    private final ClientId clientId;
    protected final SqsOpFactory<PK, D, F> sqsOpFactory;

    public BaseSqsNode(DatarouterProperties datarouterProperties, DatarouterService datarouterService, NodeParams<PK, D, F> params, SqsClientType sqsClientType, SqsClientManager sqsClientManager, ClientId clientId) {
        super(params, (ClientType)sqsClientType);
        this.datarouterProperties = datarouterProperties;
        this.datarouterService = datarouterService;
        this.params = params;
        this.sqsClientManager = sqsClientManager;
        this.clientId = clientId;
        this.queueUrl = Lazy.of(this::getOrCreateQueueUrl);
        this.sqsOpFactory = new SqsOpFactory(this, sqsClientManager, clientId);
    }

    private String getOrCreateQueueUrl() {
        String queueUrl;
        if (this.params.getQueueUrl() != null) {
            queueUrl = this.params.getQueueUrl();
        } else {
            String serviceName = this.datarouterService.getName();
            String namespace = this.params.getNamespace().orElse(String.valueOf(this.datarouterProperties.getEnvironment()) + "-" + serviceName);
            String queueName = StringTool.isEmpty((String)namespace) ? this.getFieldInfo().getTableName() : String.valueOf(namespace) + "-" + this.getFieldInfo().getTableName();
            queueUrl = this.tryCreateQueueAndGetUrl(queueName);
        }
        logger.warn("nodeName={}, queueName={}", (Object)this.getName(), (Object)queueUrl);
        return queueUrl;
    }

    private String tryCreateQueueAndGetUrl(String queueName) {
        CreateQueueRequest createQueueRequest = new CreateQueueRequest(queueName);
        try {
            return this.sqsClientManager.getAmazonSqs(this.clientId).createQueue(createQueueRequest).getQueueUrl();
        }
        catch (RuntimeException e) {
            throw new RuntimeException("queueName=" + queueName + " queueNameLength=" + queueName.length(), e);
        }
    }

    public Lazy<String> getQueueUrl() {
        return this.queueUrl;
    }

    public void ack(QueueMessageKey key, Config config) {
        this.sqsOpFactory.makeAckOp(key, config).call();
    }

    public void ackMulti(Collection<QueueMessageKey> keys, Config config) {
        this.sqsOpFactory.makeAckMultiOp(keys, config).call();
    }
}

