/*
 * Decompiled with CFR 0.152.
 */
package io.datarouter.aws.sqs.group.op;

import com.amazonaws.services.sqs.model.SendMessageRequest;
import io.datarouter.aws.sqs.BaseSqsNode;
import io.datarouter.aws.sqs.SqsClientManager;
import io.datarouter.aws.sqs.SqsDataTooLargeException;
import io.datarouter.aws.sqs.op.SqsOp;
import io.datarouter.model.databean.Databean;
import io.datarouter.model.key.primary.PrimaryKey;
import io.datarouter.model.serialize.fielder.DatabeanFielder;
import io.datarouter.storage.client.ClientId;
import io.datarouter.storage.config.Config;
import io.datarouter.util.bytes.StringByteTool;
import java.io.ByteArrayOutputStream;
import java.util.ArrayList;
import java.util.Collection;
import java.util.HashSet;
import java.util.List;
import java.util.Set;

public class SqsGroupPutMultiOp<PK extends PrimaryKey<PK>, D extends Databean<PK, D>, F extends DatabeanFielder<PK, D>>
extends SqsOp<PK, D, F, Void> {
    private final Collection<D> databeans;
    private final byte[] collectionPrefix;
    private final byte[] collectionSeparator;
    private final byte[] collectionSuffix;
    private final int maxBoundedBytesPerMessage;
    private final SqsClientManager sqsClientManager;
    private final ClientId clientId;

    public SqsGroupPutMultiOp(Collection<D> databeans, Config config, BaseSqsNode<PK, D, F> sqsNode, SqsClientManager sqsClientManager, ClientId clientId) {
        super(config, sqsNode);
        this.databeans = databeans;
        this.sqsClientManager = sqsClientManager;
        this.clientId = clientId;
        this.collectionPrefix = StringByteTool.getUtf8Bytes((String)this.codec.getCollectionPrefix());
        this.collectionSeparator = StringByteTool.getUtf8Bytes((String)this.codec.getCollectionSeparator());
        this.collectionSuffix = StringByteTool.getUtf8Bytes((String)this.codec.getCollectionSuffix());
        this.maxBoundedBytesPerMessage = 262144 - this.collectionPrefix.length - this.collectionSuffix.length;
    }

    @Override
    protected Void run() {
        if (this.databeans.size() == 0) {
            return null;
        }
        ArrayList<String> rejectedDatabeans = new ArrayList<String>();
        ArrayList<byte[]> encodedDatabeans = new ArrayList<byte[]>();
        for (Databean databean : this.databeans) {
            String databeanAsString = this.codec.toString(databean, this.fielder);
            byte[] databeanAsBytes = StringByteTool.getUtf8Bytes((String)databeanAsString);
            if (databeanAsBytes.length > this.maxBoundedBytesPerMessage) {
                rejectedDatabeans.add(databeanAsString);
                continue;
            }
            encodedDatabeans.add(databeanAsBytes);
        }
        SqsGroupPutMultiOp.makeGroups(encodedDatabeans, this.collectionSeparator, this.maxBoundedBytesPerMessage).forEach(this::flush);
        if (!rejectedDatabeans.isEmpty()) {
            throw new SqsDataTooLargeException(rejectedDatabeans);
        }
        return null;
    }

    private void flush(List<byte[]> group) {
        if (group.isEmpty()) {
            return;
        }
        String stringGroup = SqsGroupPutMultiOp.concatGroup(group, this.collectionPrefix, this.collectionSuffix, this.collectionSeparator);
        SendMessageRequest request = new SendMessageRequest(this.queueUrl, stringGroup);
        this.sqsClientManager.getAmazonSqs(this.clientId).sendMessage(request);
    }

    public static Set<List<byte[]>> makeGroups(List<byte[]> encodedDatabeans, byte[] separator, int maxBoundedBytesPerMessage) {
        HashSet<List<byte[]>> groupsToFlush = new HashSet<List<byte[]>>();
        ArrayList<byte[]> group = new ArrayList<byte[]>();
        int groupLengthWithoutSeparators = 0;
        for (byte[] encodedDatabean : encodedDatabeans) {
            int totalGroupLength = groupLengthWithoutSeparators + encodedDatabean.length + separator.length * group.size();
            if (totalGroupLength > maxBoundedBytesPerMessage) {
                groupsToFlush.add(group);
                group = new ArrayList();
                groupLengthWithoutSeparators = 0;
            }
            group.add(encodedDatabean);
            groupLengthWithoutSeparators += encodedDatabean.length;
        }
        if (!group.isEmpty()) {
            groupsToFlush.add(group);
        }
        return groupsToFlush;
    }

    public static String concatGroup(List<byte[]> group, byte[] prefix, byte[] suffix, byte[] separator) {
        ByteArrayOutputStream databeanGroup = new ByteArrayOutputStream();
        databeanGroup.write(prefix, 0, prefix.length);
        int i = 0;
        while (i < group.size()) {
            databeanGroup.write(group.get(i), 0, group.get(i).length);
            if (i < group.size() - 1) {
                databeanGroup.write(separator, 0, separator.length);
            }
            ++i;
        }
        databeanGroup.write(suffix, 0, suffix.length);
        return StringByteTool.fromUtf8Bytes((byte[])databeanGroup.toByteArray());
    }
}

