/*
 * Decompiled with CFR 0.152.
 */
package io.datarouter.aws.sqs;

import io.datarouter.aws.sqs.SqsCredentialsDto;
import io.datarouter.httpclient.json.JsonSerializer;
import io.datarouter.secret.client.SecretClient;
import io.datarouter.secret.client.SecretClientSupplier;
import io.datarouter.storage.client.ClientOptions;
import java.util.Optional;
import java.util.concurrent.ConcurrentHashMap;
import javax.inject.Inject;
import javax.inject.Named;
import javax.inject.Singleton;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;

@Singleton
public class SqsOptions {
    private static final Logger logger = LoggerFactory.getLogger(SqsOptions.class);
    protected static final String PROP_region = "region";
    protected static final String PROP_credentialsLocation = "credentials.location";
    protected static final String PROP_accessKey = "accessKey";
    protected static final String PROP_secretKey = "secretKey";
    protected static final String PROP_namespace = "namespace";
    private final ConcurrentHashMap<String, Optional<SqsCredentialsDto>> clientCredentials = new ConcurrentHashMap();
    @Inject
    private ClientOptions clientOptions;
    @Inject
    private SecretClientSupplier secretClientSupplier;
    @Inject
    @Named(value="defaultHandlerSerializer")
    private JsonSerializer jsonSerializer;

    public String getAccessKey(String clientName) {
        return this.readCredentialsSecret(clientName).map(dto -> dto.accessKey).orElseGet(() -> this.clientOptions.getRequiredString(clientName, PROP_accessKey));
    }

    public String getSecretKey(String clientName) {
        return this.readCredentialsSecret(clientName).map(dto -> dto.secretKey).orElseGet(() -> this.clientOptions.getRequiredString(clientName, PROP_secretKey));
    }

    public String getRegion(String clientName) {
        return this.clientOptions.getRequiredString(clientName, PROP_region);
    }

    private Optional<SqsCredentialsDto> readCredentialsSecret(String clientName) {
        return this.clientCredentials.computeIfAbsent(clientName, $ -> {
            Optional<String> optionalCredentialsLocation = Optional.ofNullable(this.clientOptions.getStringClientPropertyOrDefault(PROP_credentialsLocation, clientName, null));
            if (optionalCredentialsLocation.isEmpty()) {
                logger.warn("credentialsLocation not specified");
            }
            return optionalCredentialsLocation.map(credentialsLocation -> {
                try {
                    SqsCredentialsDto result = (SqsCredentialsDto)this.jsonSerializer.deserialize(((SecretClient)this.secretClientSupplier.get()).read(credentialsLocation).getValue(), SqsCredentialsDto.class);
                    logger.info("using secret at credentialsLocation={}", credentialsLocation);
                    return result;
                }
                catch (RuntimeException e) {
                    logger.error("Failed to locate credentialsLocation=" + credentialsLocation + " for clientName=" + clientName, (Throwable)e);
                    return null;
                }
            });
        });
    }
}

