/*
 * Decompiled with CFR 0.152.
 */
package io.datarouter.aws.sqs.web.handler;

import io.datarouter.aws.sqs.SqsClientManager;
import io.datarouter.aws.sqs.service.SqsQueueRegistryService;
import io.datarouter.instrumentation.changelog.ChangelogRecorder;
import io.datarouter.scanner.Scanner;
import io.datarouter.storage.client.ClientId;
import io.datarouter.storage.client.DatarouterClients;
import io.datarouter.web.handler.BaseHandler;
import io.datarouter.web.handler.mav.Mav;
import io.datarouter.web.handler.types.Param;
import io.datarouter.web.html.j2html.bootstrap4.Bootstrap4PageFactory;
import j2html.TagCreator;
import j2html.tags.DomContent;
import j2html.tags.specialized.ATag;
import j2html.tags.specialized.DivTag;
import jakarta.inject.Inject;
import java.util.List;
import software.amazon.awssdk.services.sqs.SqsClient;
import software.amazon.awssdk.services.sqs.model.DeleteQueueRequest;
import software.amazon.awssdk.services.sqs.model.GetQueueUrlRequest;
import software.amazon.awssdk.services.sqs.model.GetQueueUrlResponse;
import software.amazon.awssdk.services.sqs.model.PurgeQueueRequest;

public class SqsUpdateQueueHandler
extends BaseHandler {
    public static final String PARAM_clientName = "clientName";
    public static final String PARAM_queueName = "queueName";
    public static final String PARAM_referer = "referer";
    @Inject
    private ChangelogRecorder changelogRecorder;
    @Inject
    private SqsClientManager sqsClientManager;
    @Inject
    private DatarouterClients datarouterClients;
    @Inject
    private Bootstrap4PageFactory pageFactory;
    @Inject
    private SqsQueueRegistryService queueRegistryService;

    @BaseHandler.Handler
    private Mav deleteQueue(@Param(value="clientName") String clientName, @Param(value="queueName") String queueName, @Param(value="referer") String referer) {
        ClientId clientId = this.datarouterClients.getClientId(clientName);
        SqsClient sqs = this.sqsClientManager.getAmazonSqs(clientId);
        GetQueueUrlRequest getQueueUrlRequest = (GetQueueUrlRequest)GetQueueUrlRequest.builder().queueName(queueName).build();
        GetQueueUrlResponse queueUrlResult = sqs.getQueueUrl(getQueueUrlRequest);
        DeleteQueueRequest deleteQueueRequest = (DeleteQueueRequest)DeleteQueueRequest.builder().queueUrl(queueUrlResult.queueUrl()).build();
        sqs.deleteQueue(deleteQueueRequest);
        String message = "Deleted unreferenced SQS queue: " + queueName;
        ChangelogRecorder.DatarouterChangelogDto dto = new ChangelogRecorder.DatarouterChangelogDtoBuilder("Sqs", queueName, "deleteQueue", this.getSessionInfo().getRequiredSession().getUsername()).build();
        this.changelogRecorder.record(dto);
        return this.buildPage(referer, message);
    }

    @BaseHandler.Handler
    private Mav deleteAllUnreferencedQueues(@Param(value="clientName") String clientName, @Param(value="referer") String referer) {
        ClientId clientId = this.datarouterClients.getClientId(clientName);
        List<String> unreferencedQueueNames = this.queueRegistryService.getSqsQueuesForClient(clientId).unreferencedQueues();
        SqsClient sqs = this.sqsClientManager.getAmazonSqs(clientId);
        Scanner.of(unreferencedQueueNames).map(queueName -> (GetQueueUrlRequest)GetQueueUrlRequest.builder().queueName(queueName).build()).map(arg_0 -> ((SqsClient)sqs).getQueueUrl(arg_0)).map(GetQueueUrlResponse::queueUrl).map(queueUrl -> (DeleteQueueRequest)DeleteQueueRequest.builder().queueUrl(queueUrl).build()).forEach(arg_0 -> ((SqsClient)sqs).deleteQueue(arg_0));
        String message = "Deleted all unreferenced SQS queues";
        Scanner.of(unreferencedQueueNames).map(queueName -> new ChangelogRecorder.DatarouterChangelogDtoBuilder("Sqs", queueName, "delete unreferenced queue", this.getSessionInfo().getRequiredSession().getUsername())).map(ChangelogRecorder.DatarouterChangelogDtoBuilder::build).forEach(arg_0 -> ((ChangelogRecorder)this.changelogRecorder).record(arg_0));
        return this.buildPage(referer, message);
    }

    @BaseHandler.Handler
    private Mav purgeQueue(@Param(value="clientName") String clientName, @Param(value="queueName") String queueName, @Param(value="referer") String referer) {
        ClientId clientId = this.datarouterClients.getClientId(clientName);
        SqsClient sqs = this.sqsClientManager.getAmazonSqs(clientId);
        GetQueueUrlRequest getQueueUrlRequest = (GetQueueUrlRequest)GetQueueUrlRequest.builder().queueName(queueName).build();
        GetQueueUrlResponse queueUrlResult = sqs.getQueueUrl(getQueueUrlRequest);
        PurgeQueueRequest purgeQueueRequest = (PurgeQueueRequest)PurgeQueueRequest.builder().queueUrl(queueUrlResult.queueUrl()).build();
        sqs.purgeQueue(purgeQueueRequest);
        String message = "Purged SQS queue: " + queueName;
        ChangelogRecorder.DatarouterChangelogDto dto = new ChangelogRecorder.DatarouterChangelogDtoBuilder("Sqs", queueName, "purgeQueue", this.getSessionInfo().getRequiredSession().getUsername()).build();
        this.changelogRecorder.record(dto);
        return this.buildPage(referer, message);
    }

    private Mav buildPage(String href, String message) {
        DivTag backButton = TagCreator.div((DomContent[])new DomContent[]{((ATag)((ATag)TagCreator.a((DomContent[])new DomContent[]{TagCreator.i().withClass("fas fa-angle-left")}).withText("Go back to client details")).withHref(href)).withClass("btn btn-primary")});
        DivTag content = (DivTag)TagCreator.div((DomContent[])new DomContent[]{backButton, TagCreator.div((String)message).withClass("my-4")}).withClass("container my-4");
        return this.pageFactory.startBuilder(this.request).withContent((DomContent)content).withTitle("Update Sqs Queue").buildMav();
    }
}

