/*
 * Decompiled with CFR 0.152.
 */
package io.datarouter.aws.sqs.web;

import io.datarouter.aws.sqs.SqsClientManager;
import io.datarouter.aws.sqs.SqsClientType;
import io.datarouter.aws.sqs.config.DatarouterSqsPaths;
import io.datarouter.aws.sqs.service.QueueUrlAndName;
import io.datarouter.aws.sqs.service.SqsQueueRegistryService;
import io.datarouter.pathnode.PathNode;
import io.datarouter.scanner.Scanner;
import io.datarouter.storage.client.ClientId;
import io.datarouter.storage.client.ClientOptions;
import io.datarouter.util.duration.DatarouterDuration;
import io.datarouter.util.number.NumberFormatter;
import io.datarouter.util.number.NumberTool;
import io.datarouter.web.browse.DatarouterClientWebInspector;
import io.datarouter.web.browse.dto.DatarouterWebRequestParamsFactory;
import io.datarouter.web.handler.mav.Mav;
import io.datarouter.web.handler.mav.imp.MessageMav;
import io.datarouter.web.handler.params.Params;
import io.datarouter.web.html.j2html.J2HtmlLegendTable;
import io.datarouter.web.html.j2html.J2HtmlTable;
import io.datarouter.web.html.j2html.bootstrap4.Bootstrap4PageFactory;
import io.datarouter.web.requirejs.DatarouterWebRequireJsV2;
import j2html.TagCreator;
import j2html.tags.DomContent;
import j2html.tags.specialized.ATag;
import j2html.tags.specialized.DivTag;
import j2html.tags.specialized.TableTag;
import j2html.tags.specialized.TdTag;
import j2html.tags.specialized.ThTag;
import jakarta.inject.Inject;
import java.util.Collection;
import java.util.Comparator;
import java.util.List;
import java.util.Map;
import java.util.concurrent.TimeUnit;
import javax.servlet.http.HttpServletRequest;
import org.apache.http.client.utils.URIBuilder;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;
import software.amazon.awssdk.services.sqs.model.QueueAttributeName;

public class SqsWebInspector
implements DatarouterClientWebInspector {
    private static final Logger logger = LoggerFactory.getLogger(SqsWebInspector.class);
    @Inject
    private DatarouterWebRequestParamsFactory paramsFactory;
    @Inject
    private SqsClientManager sqsClientManager;
    @Inject
    private Bootstrap4PageFactory pageFactory;
    @Inject
    private ClientOptions clientOptions;
    @Inject
    private DatarouterSqsPaths paths;
    @Inject
    private SqsQueueRegistryService queueRegistryService;

    public Mav inspectClient(Params params, HttpServletRequest request) {
        DatarouterWebRequestParamsFactory datarouterWebRequestParamsFactory = this.paramsFactory;
        datarouterWebRequestParamsFactory.getClass();
        DatarouterWebRequestParamsFactory.DatarouterWebRequestParams clientParams = new DatarouterWebRequestParamsFactory.DatarouterWebRequestParams(datarouterWebRequestParamsFactory, params, SqsClientType.class);
        ClientId clientId = clientParams.getClientId();
        if (clientId == null) {
            return new MessageMav("Client not found");
        }
        String clientName = clientId.getName();
        Map allClientOptions = this.clientOptions.getAllClientOptions(clientName);
        DivTag content = (DivTag)TagCreator.div((DomContent[])new DomContent[]{this.buildClientPageHeader(clientName), this.buildClientOptionsTable(allClientOptions), this.buildQueueNodeTable(clientId, request), this.buildReferenceTable()}).withClass("container my-4");
        return this.pageFactory.startBuilder(request).withTitle("Datarouter Client - SQS").withRequires(new String[]{DatarouterWebRequireJsV2.SORTTABLE}).withContent((DomContent)content).buildMav();
    }

    private DivTag buildQueueNodeTable(ClientId clientId, HttpServletRequest request) {
        SqsQueueRegistryService.SqsQueuesForClient queueRegistry = this.queueRegistryService.getSqsQueuesForClient(clientId);
        List<QueueUrlAndName> knownQueuesUrlAndName = queueRegistry.knownQueueUrlByName();
        Map<String, Long> ageSByQueueName = this.sqsClientManager.getApproximateAgeOfOldestUnackedMessageSecondsGroup(clientId, Scanner.of(knownQueuesUrlAndName).map(QueueUrlAndName::queueName).list());
        List queueStatsRows = Scanner.of(knownQueuesUrlAndName).map(queueUrlAndName -> {
            String queueName = queueUrlAndName.queueName();
            String queueUrl = queueUrlAndName.queueUrl();
            String age = "error";
            Long ageS = (Long)ageSByQueueName.get(queueName);
            if (ageS != null) {
                age = new DatarouterDuration(ageS.longValue(), TimeUnit.SECONDS).toString(TimeUnit.SECONDS);
            }
            String availableCount = "error";
            String inFlightCount = "error";
            try {
                Map<QueueAttributeName, String> attributesMap = this.sqsClientManager.getAllQueueAttributes(clientId, queueUrl);
                availableCount = attributesMap.get(QueueAttributeName.APPROXIMATE_NUMBER_OF_MESSAGES);
                inFlightCount = attributesMap.get(QueueAttributeName.APPROXIMATE_NUMBER_OF_MESSAGES_NOT_VISIBLE);
            }
            catch (RuntimeException e) {
                logger.warn("failed to get attribute for queue={}", (Object)queueUrl, (Object)e);
            }
            return new SqsWebInspectorDto(queueName, availableCount, inFlightCount, age);
        }).sort(Comparator.comparing(dto -> dto.queueName)).list();
        TableTag table = new J2HtmlTable().withClasses(new String[]{"sortable table table-sm table-striped my-4 border"}).withHtmlColumn((DomContent)TagCreator.th((String)"Queue Name").withClass("col-xs-5"), row -> TagCreator.td((String)row.queueName)).withHtmlColumn((DomContent)TagCreator.th((String)"Available For Retrieval").withClass("col-xs-3"), row -> TagCreator.td((String)row.messagesAvailableForRetrieval)).withHtmlColumn((DomContent)TagCreator.th((String)"InFlight").withClass("col-xs-1"), row -> TagCreator.td((String)row.messagesInFlight)).withHtmlColumn((DomContent)TagCreator.th((String)"Total").withClass("col-xs-1"), row -> TagCreator.td((String)row.getTotalMessagesAvailable())).withHtmlColumn((DomContent)TagCreator.th((String)"Age of oldest").withClass("col-xs-1"), row -> TagCreator.td((String)String.valueOf(row.ageOfOldestMessage))).withHtmlColumn((DomContent)TagCreator.th((String)"Purge Queue").withClass("col-xs-1"), row -> {
            String href = this.buildActionPath(request, clientId, row.queueName, SqsQueueAction.PURGE);
            ATag purgeIcon = (ATag)((ATag)((ATag)((ATag)TagCreator.a((DomContent[])new DomContent[]{TagCreator.i().withClass("fas fa-skull-crossbones fa-lg")}).withHref(href)).attr("data-toggle", (Object)"tooltip")).attr("title", (Object)("Purge queue " + row.queueName))).attr("onclick", (Object)("return confirm('Are you sure you want to purge this queue " + row.queueName + "?');"));
            return (TdTag)TagCreator.td((DomContent[])new DomContent[]{purgeIcon}).withStyle("text-align:center");
        }).build((Collection)queueStatsRows);
        List<String> unreferencedQueues = queueRegistry.unreferencedQueues();
        if (unreferencedQueues.isEmpty()) {
            return (DivTag)((DivTag)TagCreator.div((DomContent[])new DomContent[]{TagCreator.h4((String)"Queues"), table}).withClass("container-fluid my-4")).withStyle("padding-left: 0px");
        }
        TableTag unreferencedQueuesTable = new J2HtmlTable().withClasses(new String[]{"sortable table table-sm table-striped my-4 border"}).withHtmlColumn((DomContent)TagCreator.th((String)"Queue Name"), TagCreator::td).withHtmlColumn((DomContent)((ThTag)TagCreator.th((DomContent[])new DomContent[]{TagCreator.a((String)"Delete All").withHref(this.buildActionPath(request, clientId, "", SqsQueueAction.DELETE_ALL))}).withStyle("text-align:center")).attr("width", (Object)"80"), row -> {
            String href = this.buildActionPath(request, clientId, (String)row, SqsQueueAction.DELETE);
            ATag trashIcon = (ATag)((ATag)((ATag)TagCreator.a((DomContent[])new DomContent[]{TagCreator.i().withClass("fas fa-trash fa-lg")}).withHref(href)).attr("data-toggle", (Object)"tooltip")).attr("title", (Object)("Delete queue " + row));
            return (TdTag)TagCreator.td((DomContent[])new DomContent[]{trashIcon}).withStyle("text-align:center");
        }).build(unreferencedQueues);
        return (DivTag)((DivTag)TagCreator.div((DomContent[])new DomContent[]{TagCreator.h4((String)"Queues"), table, TagCreator.h4((String)"Unreferenced Queues"), unreferencedQueuesTable}).withClass("container-fluid my-4")).withStyle("padding-left: 0px");
    }

    private DivTag buildReferenceTable() {
        return (DivTag)((DivTag)new J2HtmlLegendTable().withHeader("Legend").withClass("sortable table table-sm my-4 border").withEntry("Messages Available For Retrieval", "The approximate number of messages available for retrieval from the queue").withEntry("Messages In Flight", "Messages are considered to be in flight if they have been sent to a client but have not yet been deleted or have not yet reached the end of their visibility window.").withEntry("Total Messages", "A total of Available + InFlight messages").withEntry("Unreferenced Queue", "Queue which exists but the application is not aware of, usually a result of the queue being renamed, or code refactored").withEntry("Age of oldest", "The approximate age of the oldest non-deleted message in the queue.").build().withClass("container-fluid my-4")).withStyle("padding-left: 0px");
    }

    private String buildActionPath(HttpServletRequest request, ClientId clientId, String queueName, SqsQueueAction action) {
        PathNode path;
        String referer = request.getRequestURI() + "?" + request.getQueryString();
        URIBuilder uriBuilder = new URIBuilder().addParameter("clientName", clientId.getName()).addParameter("referer", referer);
        if (action == SqsQueueAction.DELETE) {
            path = this.paths.datarouter.sqs.deleteQueue;
            uriBuilder.addParameter("queueName", queueName);
        } else if (action == SqsQueueAction.PURGE) {
            path = this.paths.datarouter.sqs.purgeQueue;
            uriBuilder.addParameter("queueName", queueName);
        } else if (action == SqsQueueAction.DELETE_ALL) {
            path = this.paths.datarouter.sqs.deleteAllUnreferencedQueues;
        } else {
            return null;
        }
        return uriBuilder.setPath(request.getContextPath() + path.toSlashedString()).toString();
    }

    private static enum SqsQueueAction {
        DELETE,
        DELETE_ALL,
        PURGE;

    }

    private static class SqsWebInspectorDto {
        private final String queueName;
        private final String messagesAvailableForRetrieval;
        private final String messagesInFlight;
        private final String ageOfOldestMessage;

        private SqsWebInspectorDto(String queueName, String messagesAvailableForRetrieval, String messagesInFlight, String ageOfOldestMessage) {
            this.queueName = queueName;
            this.messagesAvailableForRetrieval = messagesAvailableForRetrieval;
            this.messagesInFlight = messagesInFlight;
            this.ageOfOldestMessage = ageOfOldestMessage;
        }

        private String getTotalMessagesAvailable() {
            long available = NumberTool.getLongNullSafe((String)this.messagesAvailableForRetrieval, (Long)0L);
            long inFlight = NumberTool.getLongNullSafe((String)this.messagesInFlight, (Long)0L);
            long total = available + inFlight;
            return NumberFormatter.addCommas((Number)total);
        }
    }
}

