/*
 * Decompiled with CFR 0.152.
 */
package io.datarouter.aws.sqs.service;

import io.datarouter.aws.sqs.SqsClientType;
import io.datarouter.aws.sqs.service.SqsQueueRegistryService;
import io.datarouter.instrumentation.relay.rml.Rml;
import io.datarouter.instrumentation.relay.rml.RmlBlock;
import io.datarouter.scanner.Scanner;
import io.datarouter.storage.client.ClientId;
import io.datarouter.storage.client.DatarouterClients;
import io.datarouter.web.config.DatarouterWebPaths;
import io.datarouter.web.digest.DailyDigest;
import io.datarouter.web.digest.DailyDigestGrouping;
import io.datarouter.web.digest.DailyDigestRmlService;
import jakarta.inject.Inject;
import jakarta.inject.Singleton;
import java.time.ZoneId;
import java.util.List;
import java.util.Optional;

@Singleton
public class SqsQueuesDailyDigest
implements DailyDigest {
    private static final String SQS_CATEGORY = "sqs";
    private static final String UNREFERENCED_CATEGORY = "unreferenced";
    @Inject
    private DatarouterClients datarouterClients;
    @Inject
    private DatarouterWebPaths paths;
    @Inject
    private SqsQueueRegistryService queueRegistryService;
    @Inject
    private DailyDigestRmlService digestService;

    public String getTitle() {
        return "Sqs Queues";
    }

    public DailyDigest.DailyDigestType getType() {
        return DailyDigest.DailyDigestType.ACTIONABLE;
    }

    public DailyDigestGrouping getGrouping() {
        return DailyDigestGrouping.LOW;
    }

    public Optional<RmlBlock> getRelayContent(ZoneId zoneId) {
        List<String> unreferencedQueues = this.getUnreferencedQueues();
        if (unreferencedQueues.isEmpty()) {
            return Optional.empty();
        }
        return Optional.of(Rml.paragraph((RmlBlock[])new RmlBlock[]{this.digestService.makeHeading("Unreferenced Sqs Queues", this.paths.datarouter.client.inspectClient, "?clientName=sqs"), Rml.table((RmlBlock[])new RmlBlock[]{Rml.tableRow((RmlBlock[])new RmlBlock[]{Rml.tableHeader((RmlBlock[])new RmlBlock[]{Rml.text((String)"Queue Name")})})}).with(unreferencedQueues.stream().map(Rml::text).map(rmlText -> Rml.tableCell((RmlBlock[])new RmlBlock[]{rmlText})).map(rmlTableCell -> Rml.tableRow((RmlBlock[])new RmlBlock[]{rmlTableCell})))}));
    }

    public List<DailyDigest.DailyDigestPlatformTask> getTasks(ZoneId zoneId) {
        return Scanner.of(this.getUnreferencedQueues()).map(unreferenced -> new DailyDigest.DailyDigestPlatformTask(List.of(SQS_CATEGORY, UNREFERENCED_CATEGORY, unreferenced), List.of(SQS_CATEGORY, UNREFERENCED_CATEGORY), "Unreferenced SQS queue " + unreferenced, (RmlBlock)Rml.paragraph((RmlBlock[])new RmlBlock[]{Rml.text((String)"Sqs queue "), Rml.text((String)unreferenced).code(), Rml.text((String)" is unreferenced. "), this.digestService.makeLink("View queues", this.paths.datarouter.client.inspectClient, "?clientName=sqs")}))).list();
    }

    private List<String> getUnreferencedQueues() {
        ClientId clientId = Scanner.of((Iterable)this.datarouterClients.getClientIds()).include(client -> this.datarouterClients.getClientTypeInstance(client) instanceof SqsClientType).findFirst().orElse(null);
        if (clientId == null) {
            return List.of();
        }
        return this.queueRegistryService.getSqsQueuesForClient(clientId).unreferencedQueues();
    }
}

