/*
 * Decompiled with CFR 0.152.
 */
package io.datarouter.aws.sqs.op;

import io.datarouter.aws.sqs.BaseSqsNode;
import io.datarouter.aws.sqs.SqsClientManager;
import io.datarouter.aws.sqs.op.SqsOp;
import io.datarouter.model.databean.Databean;
import io.datarouter.model.key.primary.PrimaryKey;
import io.datarouter.model.serialize.fielder.DatabeanFielder;
import io.datarouter.scanner.Scanner;
import io.datarouter.storage.client.ClientId;
import io.datarouter.storage.config.Config;
import io.datarouter.storage.queue.QueueMessageKey;
import io.datarouter.util.concurrent.UncheckedInterruptedException;
import java.util.Collection;
import java.util.List;
import java.util.UUID;
import software.amazon.awssdk.core.exception.AbortedException;
import software.amazon.awssdk.services.sqs.model.DeleteMessageBatchRequest;
import software.amazon.awssdk.services.sqs.model.DeleteMessageBatchRequestEntry;

public class SqsAckMultiOp<PK extends PrimaryKey<PK>, D extends Databean<PK, D>, F extends DatabeanFielder<PK, D>>
extends SqsOp<PK, D, F, Void> {
    private final Collection<QueueMessageKey> keys;
    private final SqsClientManager sqsClientManager;
    private final ClientId clientId;

    public SqsAckMultiOp(Collection<QueueMessageKey> keys, Config config, BaseSqsNode<PK, D, F> sqsNode, SqsClientManager sqsClientManager, ClientId clientId) {
        super(config, sqsNode);
        this.keys = keys;
        this.sqsClientManager = sqsClientManager;
        this.clientId = clientId;
    }

    @Override
    protected Void run() {
        for (List batch : Scanner.of(this.keys).batch(10).iterable()) {
            DeleteMessageBatchRequest deleteRequest = (DeleteMessageBatchRequest)Scanner.of((Iterable)batch).map(key -> (DeleteMessageBatchRequestEntry)DeleteMessageBatchRequestEntry.builder().id(UUID.randomUUID().toString()).receiptHandle(new String(key.getHandle())).build()).listTo(deleteEntries -> (DeleteMessageBatchRequest)DeleteMessageBatchRequest.builder().queueUrl(this.queueUrl).entries((Collection)deleteEntries).build());
            try {
                this.sqsClientManager.getAmazonSqs(this.clientId).deleteMessageBatch(deleteRequest);
            }
            catch (AbortedException e) {
                throw new UncheckedInterruptedException("", (Exception)((Object)e));
            }
        }
        return null;
    }
}

