/*
 * Decompiled with CFR 0.152.
 */
package io.datarouter.aws.sqs.op;

import io.datarouter.aws.sqs.BaseSqsNode;
import io.datarouter.aws.sqs.SqsClientManager;
import io.datarouter.aws.sqs.op.SqsOp;
import io.datarouter.model.databean.Databean;
import io.datarouter.model.key.primary.PrimaryKey;
import io.datarouter.model.serialize.fielder.DatabeanFielder;
import io.datarouter.storage.client.ClientId;
import io.datarouter.storage.config.Config;
import io.datarouter.util.concurrent.UncheckedInterruptedException;
import java.time.Duration;
import java.util.List;
import software.amazon.awssdk.core.exception.AbortedException;
import software.amazon.awssdk.services.sqs.model.Message;
import software.amazon.awssdk.services.sqs.model.ReceiveMessageRequest;
import software.amazon.awssdk.services.sqs.model.ReceiveMessageResponse;

public abstract class BaseSqsPeekMultiOp<PK extends PrimaryKey<PK>, D extends Databean<PK, D>, F extends DatabeanFielder<PK, D>, T>
extends SqsOp<PK, D, F, List<T>> {
    private final SqsClientManager sqsClientManager;
    private final ClientId clientId;

    public BaseSqsPeekMultiOp(Config config, BaseSqsNode<PK, D, F> sqsNode, SqsClientManager sqsClientManager, ClientId clientId) {
        super(config, sqsNode);
        this.sqsClientManager = sqsClientManager;
        this.clientId = clientId;
    }

    @Override
    protected final List<T> run() {
        ReceiveMessageResponse response;
        ReceiveMessageRequest request = this.makeRequest();
        try {
            response = this.sqsClientManager.getAmazonSqs(this.clientId).receiveMessage(request);
        }
        catch (AbortedException e) {
            throw new UncheckedInterruptedException("", (Exception)((Object)e));
        }
        List messages = response.messages();
        return messages.isEmpty() ? List.of() : this.extractDatabeans(messages);
    }

    protected abstract List<T> extractDatabeans(List<Message> var1);

    private ReceiveMessageRequest makeRequest() {
        ReceiveMessageRequest.Builder request = ReceiveMessageRequest.builder().queueUrl(this.queueUrl);
        Duration configTimeout = this.config.findTimeout().filter(timeout -> timeout.compareTo(BaseSqsNode.MAX_TIMEOUT) <= 0).orElse(BaseSqsNode.MAX_TIMEOUT);
        request.waitTimeSeconds(Integer.valueOf(Math.toIntExact(configTimeout.getSeconds())));
        long visibilityTimeoutMs = this.config.findVisibilityTimeoutMs().orElse(BaseSqsNode.DEFAULT_VISIBILITY_TIMEOUT_MS);
        request.visibilityTimeout(Integer.valueOf((int)Duration.ofMillis(visibilityTimeoutMs).getSeconds()));
        request.maxNumberOfMessages(this.config.findLimit().orElse(10));
        request.messageAttributeNames(new String[]{"ALL"});
        return (ReceiveMessageRequest)request.build();
    }
}

