/*
 * Decompiled with CFR 0.152.
 */
package io.datarouter.aws.sqs.group.op;

import io.datarouter.aws.sqs.BaseSqsNode;
import io.datarouter.aws.sqs.SqsClientManager;
import io.datarouter.aws.sqs.SqsDataTooLargeException;
import io.datarouter.aws.sqs.op.SqsOp;
import io.datarouter.bytes.codec.stringcodec.StringCodec;
import io.datarouter.model.databean.Databean;
import io.datarouter.model.key.primary.PrimaryKey;
import io.datarouter.model.serialize.fielder.DatabeanFielder;
import io.datarouter.model.util.CommonFieldSizes;
import io.datarouter.storage.client.ClientId;
import io.datarouter.storage.config.Config;
import io.datarouter.util.concurrent.UncheckedInterruptedException;
import java.util.ArrayList;
import java.util.Collection;
import java.util.List;
import software.amazon.awssdk.core.exception.AbortedException;
import software.amazon.awssdk.services.sqs.model.SendMessageRequest;

public class SqsGroupPutMultiOp<PK extends PrimaryKey<PK>, D extends Databean<PK, D>, F extends DatabeanFielder<PK, D>>
extends SqsOp<PK, D, F, Void> {
    private final Collection<D> databeans;
    private final int maxBoundedBytesPerMessage;
    private final SqsClientManager sqsClientManager;
    private final ClientId clientId;

    public SqsGroupPutMultiOp(Collection<D> databeans, Config config, BaseSqsNode<PK, D, F> sqsNode, SqsClientManager sqsClientManager, ClientId clientId) {
        super(config, sqsNode);
        this.databeans = databeans;
        this.sqsClientManager = sqsClientManager;
        this.clientId = clientId;
        this.maxBoundedBytesPerMessage = CommonFieldSizes.MAX_SQS_SIZE - this.codec.getCollectionPrefixBytes().length - this.codec.getCollectionSuffixBytes().length;
    }

    @Override
    protected Void run() {
        if (this.databeans.isEmpty()) {
            return null;
        }
        ArrayList<String> rejectedDatabeans = new ArrayList<String>();
        ArrayList<byte[]> encodedDatabeans = new ArrayList<byte[]>();
        for (Databean databean : this.databeans) {
            String databeanAsString = this.codec.toString(databean, this.fielder);
            byte[] databeanAsBytes = StringCodec.UTF_8.encode(databeanAsString);
            if (databeanAsBytes.length > this.maxBoundedBytesPerMessage) {
                rejectedDatabeans.add(databeanAsString);
                continue;
            }
            encodedDatabeans.add(databeanAsBytes);
        }
        this.codec.makeGroups(encodedDatabeans, this.maxBoundedBytesPerMessage).forEach(this::flush);
        if (!rejectedDatabeans.isEmpty()) {
            throw new SqsDataTooLargeException(rejectedDatabeans);
        }
        return null;
    }

    private void flush(List<byte[]> group) {
        if (group.isEmpty()) {
            return;
        }
        String stringGroup = StringCodec.UTF_8.decode(this.codec.concatGroup(group));
        SendMessageRequest request = (SendMessageRequest)SendMessageRequest.builder().queueUrl(this.queueUrl).messageBody(stringGroup).build();
        try {
            this.sqsClientManager.getAmazonSqs(this.clientId).sendMessage(request);
        }
        catch (AbortedException e) {
            throw new UncheckedInterruptedException("", (Exception)((Object)e));
        }
    }
}

