/*
 * Decompiled with CFR 0.152.
 */
package io.datarouter.aws.sqs.config;

import io.datarouter.aws.sqs.config.DatarouterSqsRouteSet;
import io.datarouter.aws.sqs.config.DatarouterSqsSettingsRoot;
import io.datarouter.aws.sqs.config.DatarouterSqsTriggerGroup;
import io.datarouter.aws.sqs.service.SqsQueuesDailyDigest;
import io.datarouter.instrumentation.test.TestableService;
import io.datarouter.job.BaseTriggerGroup;
import io.datarouter.plugin.PluginConfigKey;
import io.datarouter.plugin.PluginConfigType;
import io.datarouter.plugin.PluginConfigValue;
import io.datarouter.web.config.BaseWebPlugin;
import java.util.ArrayList;
import java.util.List;
import java.util.Set;

public class DatarouterSqsPlugin
extends BaseWebPlugin {
    private DatarouterSqsPlugin(DatarouterSqsPluginBuilder builder) {
        this.addSettingRoot(DatarouterSqsSettingsRoot.class);
        this.addRouteSet(DatarouterSqsRouteSet.class);
        this.addPluginEntry(BaseTriggerGroup.KEY, DatarouterSqsTriggerGroup.class);
        this.addPluginEntry(builder.getCatalogServiceNames());
        this.addDatarouterGithubDocLink("datarouter-aws-sqs");
        this.addDailyDigest(SqsQueuesDailyDigest.class);
        builder.testableServiceClasses.forEach(arg_0 -> ((DatarouterSqsPlugin)this).addTestable(arg_0));
    }

    public static class DatarouterSqsPluginBuilder {
        private final List<Class<? extends TestableService>> testableServiceClasses = new ArrayList<Class<? extends TestableService>>();
        private final List<String> catalogServiceNames = new ArrayList<String>();

        public DatarouterSqsPluginBuilder addTestableClass(Class<? extends TestableService> testableService) {
            this.testableServiceClasses.add(testableService);
            return this;
        }

        public DatarouterSqsPluginBuilder addServiceNames(Set<String> serviceNames) {
            this.catalogServiceNames.addAll(serviceNames);
            return this;
        }

        public DatarouterSqsPlugin build() {
            return new DatarouterSqsPlugin(this);
        }

        public ServiceNameRegistry getCatalogServiceNames() {
            return new ServiceNameRegistry(this.catalogServiceNames);
        }
    }

    public static class ServiceNameRegistry
    implements PluginConfigValue<ServiceNameRegistry> {
        public static final PluginConfigKey<ServiceNameRegistry> KEY = new PluginConfigKey("serviceNameRegistry", PluginConfigType.INSTANCE_SINGLE);
        public final List<String> serviceNames;

        public ServiceNameRegistry(List<String> serviceNames) {
            this.serviceNames = serviceNames;
        }

        public PluginConfigKey<ServiceNameRegistry> getKey() {
            return KEY;
        }
    }
}

