/*
 * Decompiled with CFR 0.152.
 */
package io.datarouter.aws.sqs.blob.op;

import io.datarouter.aws.sqs.BaseSqsNode;
import io.datarouter.aws.sqs.SqsClientManager;
import io.datarouter.aws.sqs.op.SqsBlobOp;
import io.datarouter.bytes.codec.stringcodec.StringCodec;
import io.datarouter.scanner.Scanner;
import io.datarouter.storage.client.ClientId;
import io.datarouter.storage.config.Config;
import io.datarouter.storage.queue.RawBlobQueueMessage;
import io.datarouter.util.concurrent.UncheckedInterruptedException;
import java.time.Duration;
import java.util.List;
import java.util.Map;
import software.amazon.awssdk.core.exception.AbortedException;
import software.amazon.awssdk.services.sqs.model.Message;
import software.amazon.awssdk.services.sqs.model.MessageAttributeValue;
import software.amazon.awssdk.services.sqs.model.ReceiveMessageRequest;
import software.amazon.awssdk.services.sqs.model.ReceiveMessageResponse;

public class SqsBlobPeekOp
extends SqsBlobOp<RawBlobQueueMessage> {
    public SqsBlobPeekOp(Config config, SqsClientManager sqsClientManager, ClientId clientId, String queueUrl) {
        super(sqsClientManager, clientId, config, queueUrl);
    }

    @Override
    protected RawBlobQueueMessage run() {
        ReceiveMessageResponse response;
        ReceiveMessageRequest request = this.makeRequest();
        try {
            response = this.sqsClientManager.getAmazonSqs(this.clientId).receiveMessage(request);
        }
        catch (AbortedException e) {
            throw new UncheckedInterruptedException("", (Exception)((Object)e));
        }
        List messages = response.messages();
        if (messages.isEmpty()) {
            return null;
        }
        Message message = (Message)messages.getFirst();
        byte[] data = SqsBlobOp.SQS_BLOB_BASE_64_CODEC.decode(message.body());
        byte[] receiptHandle = StringCodec.UTF_8.encode(message.receiptHandle());
        Map attributes = Scanner.of(message.messageAttributes().entrySet()).toMap(Map.Entry::getKey, entry -> ((MessageAttributeValue)entry.getValue()).stringValue());
        return new RawBlobQueueMessage(receiptHandle, data, attributes);
    }

    private ReceiveMessageRequest makeRequest() {
        ReceiveMessageRequest.Builder request = ReceiveMessageRequest.builder().queueUrl(this.queueUrl);
        Duration configTimeout = this.config.findTimeout().filter(timeout -> timeout.compareTo(BaseSqsNode.MAX_TIMEOUT) <= 0).orElse(BaseSqsNode.MAX_TIMEOUT);
        request.waitTimeSeconds(Integer.valueOf(Math.toIntExact(configTimeout.getSeconds())));
        long visibilityTimeoutMs = this.config.findVisibilityTimeoutMs().orElse(BaseSqsNode.DEFAULT_VISIBILITY_TIMEOUT_MS);
        request.visibilityTimeout(Integer.valueOf((int)Duration.ofMillis(visibilityTimeoutMs).getSeconds()));
        request.maxNumberOfMessages(Integer.valueOf(1));
        request.messageAttributeNames(new String[]{"ALL"});
        return (ReceiveMessageRequest)request.build();
    }
}

