/*
 * Decompiled with CFR 0.152.
 */
package io.datarouter.aws.sqs.blob.op;

import io.datarouter.aws.sqs.SqsClientManager;
import io.datarouter.aws.sqs.op.SqsBlobOp;
import io.datarouter.bytes.codec.stringcodec.StringCodec;
import io.datarouter.storage.client.ClientId;
import io.datarouter.storage.config.Config;
import io.datarouter.util.concurrent.UncheckedInterruptedException;
import software.amazon.awssdk.core.exception.AbortedException;
import software.amazon.awssdk.services.sqs.model.DeleteMessageRequest;

public class SqsBlobAckOp
extends SqsBlobOp<Void> {
    private final String handle;

    public SqsBlobAckOp(byte[] handle, Config config, SqsClientManager sqsClientManager, ClientId clientId, String queueUrl) {
        super(sqsClientManager, clientId, config, queueUrl);
        this.handle = StringCodec.UTF_8.decode(handle);
    }

    @Override
    protected Void run() {
        DeleteMessageRequest deleteRequest = (DeleteMessageRequest)DeleteMessageRequest.builder().queueUrl(this.queueUrl).receiptHandle(this.handle).build();
        try {
            this.sqsClientManager.getAmazonSqs(this.clientId).deleteMessage(deleteRequest);
        }
        catch (AbortedException e) {
            throw new UncheckedInterruptedException("", (Exception)((Object)e));
        }
        return null;
    }
}

