/*
 * Decompiled with CFR 0.152.
 */
package io.datarouter.aws.sqs;

import io.datarouter.storage.config.properties.EnvironmentName;
import io.datarouter.storage.config.properties.ServiceName;
import io.datarouter.util.string.StringTool;
import jakarta.inject.Inject;
import jakarta.inject.Singleton;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;

@Singleton
public class SqsQueueNameService {
    private static final Logger logger = LoggerFactory.getLogger(SqsQueueNameService.class);
    public static final int MIN_QUEUE_NAME_LENGTH = 1;
    public static final int MAX_QUEUE_NAME_LENGTH = 80;
    @Inject
    private EnvironmentName environmentName;
    @Inject
    private ServiceName serviceName;

    public String buildDefaultNamespace() {
        return this.buildDefaultNamespaceForEnvironment(this.environmentName.get());
    }

    public String buildDefaultNamespaceForEnvironment(String environment) {
        return environment + "-" + this.serviceName.get();
    }

    public String buildDefaultQueueName(String tableName) {
        return this.buildDefaultQueueNameForEnvironment(this.environmentName.get(), tableName);
    }

    public String buildDefaultQueueNameForEnvironment(String environment, String tableName) {
        String queueName;
        String namespace = this.buildDefaultNamespaceForEnvironment(environment);
        String string = queueName = StringTool.isEmpty((String)namespace) ? tableName : namespace + "-" + tableName;
        if (queueName.length() > 80) {
            logger.error("queue={} overflows the max size {}", (Object)queueName, (Object)80);
        }
        return queueName;
    }

    public String buildQueueName(String queueUrl, String tableName) {
        if (queueUrl != null) {
            return queueUrl.substring(queueUrl.lastIndexOf(47) + 1);
        }
        return this.buildDefaultQueueName(tableName);
    }
}

