/*
 * Decompiled with CFR 0.152.
 */
package io.datarouter.aws.sqs;

import io.datarouter.aws.sqs.SqsCredentialsDto;
import io.datarouter.secret.op.SecretOpConfig;
import io.datarouter.secret.op.SecretOpReason;
import io.datarouter.secret.service.SecretNamespacer;
import io.datarouter.secret.service.SecretService;
import io.datarouter.storage.client.ClientOptions;
import jakarta.inject.Inject;
import jakarta.inject.Singleton;
import java.util.Optional;
import java.util.concurrent.ConcurrentHashMap;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;

@Singleton
public class SqsOptions {
    private static final Logger logger = LoggerFactory.getLogger(SqsOptions.class);
    protected static final String PROP_region = "region";
    protected static final String PROP_credentialsLocation = "credentials.location";
    protected static final String PROP_accessKey = "accessKey";
    protected static final String PROP_secretKey = "secretKey";
    protected static final String PROP_namespace = "namespace";
    private final ConcurrentHashMap<String, Optional<SqsCredentialsDto>> clientCredentials = new ConcurrentHashMap();
    @Inject
    private ClientOptions clientOptions;
    @Inject
    private SecretNamespacer secretNamespacer;
    @Inject
    private SecretService secretService;

    public String getAccessKey(String clientName) {
        return this.readCredentialsSecret(clientName).map(SqsCredentialsDto::accessKey).orElseGet(() -> this.clientOptions.getRequiredString(clientName, PROP_accessKey));
    }

    public String getSecretKey(String clientName) {
        return this.readCredentialsSecret(clientName).map(SqsCredentialsDto::secretKey).orElseGet(() -> this.clientOptions.getRequiredString(clientName, PROP_secretKey));
    }

    public String getRegion(String clientName) {
        return this.clientOptions.getRequiredString(clientName, PROP_region);
    }

    private Optional<SqsCredentialsDto> readCredentialsSecret(String clientName) {
        return this.clientCredentials.computeIfAbsent(clientName, string2 -> {
            Optional optionalCredentialsLocation = this.clientOptions.optString(clientName, PROP_credentialsLocation);
            if (optionalCredentialsLocation.isEmpty()) {
                logger.warn("credentialsLocation not specified");
            }
            return optionalCredentialsLocation.map(credentialsLocation -> {
                String namespacedLocationForLogs = this.secretNamespacer.sharedNamespaced(credentialsLocation);
                try {
                    SecretOpConfig config = SecretOpConfig.builder((SecretOpReason)SecretOpReason.automatedOp((String)this.getClass().getName())).useSharedNamespace().build();
                    SqsCredentialsDto result = (SqsCredentialsDto)this.secretService.read(credentialsLocation, SqsCredentialsDto.class, config);
                    logger.info("using secret at credentialsLocation={}", (Object)namespacedLocationForLogs);
                    return result;
                }
                catch (RuntimeException e) {
                    logger.error("Failed to locate credentialsLocation={} for clientName={}", new Object[]{namespacedLocationForLogs, clientName, e});
                    return null;
                }
            });
        });
    }
}

