/*
 * Decompiled with CFR 0.152.
 */
package io.datarouter.aws.sqs;

import io.datarouter.aws.sqs.AmazonSqsHolder;
import io.datarouter.aws.sqs.config.DatarouterSqsSettingsRoot;
import io.datarouter.instrumentation.metric.Metrics;
import io.datarouter.scanner.Scanner;
import io.datarouter.storage.client.BaseClientManager;
import io.datarouter.storage.client.ClientId;
import jakarta.inject.Inject;
import jakarta.inject.Singleton;
import java.time.Instant;
import java.time.temporal.ChronoUnit;
import java.util.Collection;
import java.util.HashMap;
import java.util.List;
import java.util.Map;
import java.util.concurrent.atomic.LongAdder;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;
import software.amazon.awssdk.services.cloudwatch.CloudWatchClient;
import software.amazon.awssdk.services.cloudwatch.model.Dimension;
import software.amazon.awssdk.services.cloudwatch.model.GetMetricDataRequest;
import software.amazon.awssdk.services.cloudwatch.model.GetMetricDataResponse;
import software.amazon.awssdk.services.cloudwatch.model.Metric;
import software.amazon.awssdk.services.cloudwatch.model.MetricDataQuery;
import software.amazon.awssdk.services.cloudwatch.model.MetricStat;
import software.amazon.awssdk.services.sqs.SqsClient;
import software.amazon.awssdk.services.sqs.model.GetQueueAttributesRequest;
import software.amazon.awssdk.services.sqs.model.QueueAttributeName;
import software.amazon.awssdk.services.sqs.model.SetQueueAttributesRequest;

@Singleton
public class SqsClientManager
extends BaseClientManager {
    private static final Logger logger = LoggerFactory.getLogger(SqsClientManager.class);
    @Inject
    private AmazonSqsHolder amazonSqsHolder;
    @Inject
    private DatarouterSqsSettingsRoot datarouterSqsSettingsRoot;

    public void shutdown(ClientId clientId) {
        this.amazonSqsHolder.get(clientId).close();
    }

    protected void safeInitClient(ClientId clientId) {
        this.amazonSqsHolder.registerClient(clientId);
    }

    public SqsClient getAmazonSqs(ClientId clientId) {
        this.initClient(clientId);
        return this.amazonSqsHolder.get(clientId);
    }

    public String getQueueAttribute(ClientId clientId, String queueUrl, QueueAttributeName attributeName) {
        return this.getQueueAttributes(clientId, queueUrl, List.of(attributeName)).get(attributeName);
    }

    public Map<QueueAttributeName, String> getAllQueueAttributes(ClientId clientId, String sqsQueueUrl) {
        return this.getQueueAttributes(clientId, sqsQueueUrl, List.of(QueueAttributeName.ALL));
    }

    private MetricDataQuery createMetricDataQuery(String queueName) {
        Metric metric = (Metric)Metric.builder().metricName("ApproximateAgeOfOldestMessage").dimensions(new Dimension[]{(Dimension)Dimension.builder().name("QueueName").value(queueName).build()}).namespace("AWS/SQS").build();
        MetricStat metricStat = (MetricStat)MetricStat.builder().stat("Average").period(Integer.valueOf(60)).metric(metric).build();
        return (MetricDataQuery)MetricDataQuery.builder().id(queueName.replace("-", "").replace(":", "")).metricStat(metricStat).build();
    }

    public Map<String, Long> getApproximateAgeOfOldestUnackedMessageSecondsGroup(ClientId clientId, List<String> queueNames) {
        this.count("queue", queueNames.size());
        HashMap<String, Long> queueNamesAndApproximateAgeOfOldestMessage = new HashMap<String, Long>();
        CloudWatchClient cloudWatch = this.amazonSqsHolder.getCloudWatch(clientId);
        if (cloudWatch == null) {
            logger.error("CloudwatchClient is null for clientid={}", (Object)clientId);
            return Map.of();
        }
        List metricDataQueries = Scanner.of(queueNames).map(this::createMetricDataQuery).list();
        String nextToken = null;
        Instant endTime = Instant.now().plus(1L, ChronoUnit.MINUTES).truncatedTo(ChronoUnit.MINUTES);
        Instant startTime = endTime.minus(((Integer)this.datarouterSqsSettingsRoot.cloudWatchMinuteBack.get()).intValue(), ChronoUnit.MINUTES);
        int requestCount = 0;
        int resultCount = 0;
        LongAdder datapointCount = new LongAdder();
        try {
            do {
                GetMetricDataRequest.Builder requestBuilder = GetMetricDataRequest.builder().startTime(startTime).endTime(endTime).metricDataQueries((Collection)metricDataQueries);
                if (nextToken != null) {
                    requestBuilder.nextToken(nextToken);
                }
                GetMetricDataResponse response = cloudWatch.getMetricData((GetMetricDataRequest)requestBuilder.build());
                nextToken = response.nextToken();
                ++requestCount;
                this.count("request", 1L);
                List result = response.metricDataResults();
                resultCount += result.size();
                this.count("result", result.size());
                result.forEach(res -> {
                    logger.debug("{}", res);
                    datapointCount.add(res.values().size());
                    this.count("datapoint", res.values().size());
                    String queueName = res.label();
                    if (res.values().isEmpty()) {
                        logger.warn("no data for {}", (Object)queueName);
                    } else {
                        this.count("queueWithData", 1L);
                        queueNamesAndApproximateAgeOfOldestMessage.put(queueName, ((Double)res.values().getFirst()).longValue());
                    }
                });
            } while (nextToken != null);
        }
        catch (RuntimeException e) {
            logger.error("Failed to obtain metrics from cloudwatch", (Throwable)e);
            return Map.of();
        }
        logger.warn("start={} end={} queues={} requests={} result={} data={}", new Object[]{startTime, endTime, queueNames.size(), requestCount, resultCount, datapointCount.sum()});
        logger.debug("result={}", queueNamesAndApproximateAgeOfOldestMessage);
        return queueNamesAndApproximateAgeOfOldestMessage;
    }

    private void count(String string, long delta) {
        Metrics.count((String)("GetMetricData ApproximateAgeOfOldestMessage " + string), (long)delta);
    }

    public Map<QueueAttributeName, String> getQueueAttributes(ClientId clientId, String queueUrl, List<QueueAttributeName> attributes) {
        GetQueueAttributesRequest request = (GetQueueAttributesRequest)GetQueueAttributesRequest.builder().attributeNames(attributes).queueUrl(queueUrl).build();
        return this.getAmazonSqs(clientId).getQueueAttributes(request).attributes();
    }

    public void updateAttr(ClientId clientId, String queueUrl, QueueAttributeName key, Object value) {
        Map<QueueAttributeName, String> attributes = Map.of(key, String.valueOf(value));
        SetQueueAttributesRequest request = (SetQueueAttributesRequest)SetQueueAttributesRequest.builder().attributes(attributes).queueUrl(queueUrl).build();
        this.getAmazonSqs(clientId).setQueueAttributes(request);
    }
}

