/*
 * Decompiled with CFR 0.152.
 */
package io.datarouter.aws.sqs;

import io.datarouter.aws.sqs.SqsOptions;
import io.datarouter.storage.client.ClientId;
import io.datarouter.web.config.AwsSupport;
import jakarta.inject.Inject;
import jakarta.inject.Singleton;
import java.util.Map;
import java.util.concurrent.ConcurrentHashMap;
import software.amazon.awssdk.auth.credentials.AwsBasicCredentials;
import software.amazon.awssdk.auth.credentials.AwsCredentials;
import software.amazon.awssdk.auth.credentials.AwsCredentialsProvider;
import software.amazon.awssdk.auth.credentials.StaticCredentialsProvider;
import software.amazon.awssdk.http.SdkHttpClient;
import software.amazon.awssdk.http.apache.ApacheHttpClient;
import software.amazon.awssdk.regions.Region;
import software.amazon.awssdk.services.cloudwatch.CloudWatchClient;
import software.amazon.awssdk.services.cloudwatch.CloudWatchClientBuilder;
import software.amazon.awssdk.services.sqs.SqsClient;
import software.amazon.awssdk.services.sqs.SqsClientBuilder;

@Singleton
public class AmazonSqsHolder {
    private final Map<ClientId, SqsClient> amazonSqsByClient = new ConcurrentHashMap<ClientId, SqsClient>();
    private final Map<ClientId, CloudWatchClient> amazonCloudWatchByClient = new ConcurrentHashMap<ClientId, CloudWatchClient>();
    @Inject
    private SqsOptions sqsOptions;
    @Inject
    private AwsSupport awsSupport;

    public void registerClient(ClientId clientId) {
        if (this.amazonSqsByClient.containsKey(clientId)) {
            throw new RuntimeException(String.valueOf(clientId) + " already registered an sqs client");
        }
        SdkHttpClient httpClient = ApacheHttpClient.builder().maxConnections(Integer.valueOf(200)).build();
        AwsBasicCredentials credentials = AwsBasicCredentials.create((String)this.sqsOptions.getAccessKey(clientId.getName()), (String)this.sqsOptions.getSecretKey(clientId.getName()));
        StaticCredentialsProvider awsCredentialsProvider = StaticCredentialsProvider.create((AwsCredentials)credentials);
        SqsClient amazonSqs = (SqsClient)((SqsClientBuilder)((SqsClientBuilder)((SqsClientBuilder)SqsClient.builder().region(Region.of((String)this.sqsOptions.getRegion(clientId.getName())))).credentialsProvider((AwsCredentialsProvider)awsCredentialsProvider)).httpClient(httpClient)).build();
        this.awsSupport.registerConnectionManagerFromHttpClient("sqs " + clientId.getName(), (Object)httpClient);
        this.amazonSqsByClient.put(clientId, amazonSqs);
        CloudWatchClient cloudWatchClient = (CloudWatchClient)((CloudWatchClientBuilder)((CloudWatchClientBuilder)CloudWatchClient.builder().region(Region.of((String)this.sqsOptions.getRegion(clientId.getName())))).credentialsProvider((AwsCredentialsProvider)awsCredentialsProvider)).build();
        this.amazonCloudWatchByClient.put(clientId, cloudWatchClient);
    }

    public SqsClient get(ClientId clientId) {
        return this.amazonSqsByClient.get(clientId);
    }

    public CloudWatchClient getCloudWatch(ClientId clientId) {
        return this.amazonCloudWatchByClient.get(clientId);
    }
}

