/*
 * Decompiled with CFR 0.152.
 */
package io.datarouter.aws.sqs.single.op;

import com.amazonaws.AbortedException;
import com.amazonaws.services.sqs.model.SendMessageBatchRequest;
import com.amazonaws.services.sqs.model.SendMessageBatchRequestEntry;
import io.datarouter.aws.sqs.BaseSqsNode;
import io.datarouter.aws.sqs.SqsClientManager;
import io.datarouter.aws.sqs.SqsDataTooLargeException;
import io.datarouter.aws.sqs.op.SqsOp;
import io.datarouter.bytes.codec.stringcodec.StringCodec;
import io.datarouter.model.databean.Databean;
import io.datarouter.model.key.primary.PrimaryKey;
import io.datarouter.model.serialize.fielder.DatabeanFielder;
import io.datarouter.model.util.CommonFieldSizes;
import io.datarouter.storage.client.ClientId;
import io.datarouter.storage.config.Config;
import io.datarouter.storage.serialize.fieldcache.FieldGeneratorTool;
import io.datarouter.storage.serialize.fieldcache.PhysicalDatabeanFieldInfo;
import io.datarouter.util.concurrent.UncheckedInterruptedException;
import java.util.ArrayList;
import java.util.Collection;
import java.util.List;
import java.util.UUID;

public class SqsPutMultiOp<PK extends PrimaryKey<PK>, D extends Databean<PK, D>, F extends DatabeanFielder<PK, D>>
extends SqsOp<PK, D, F, Void> {
    private final Collection<D> databeans;
    private final SqsClientManager sqsClientManager;
    private final ClientId clientId;

    public SqsPutMultiOp(Collection<D> databeans, Config config, BaseSqsNode<PK, D, F> sqsNode, SqsClientManager sqsClientManager, ClientId clientId) {
        super(config, sqsNode);
        this.databeans = databeans;
        this.sqsClientManager = sqsClientManager;
        this.clientId = clientId;
    }

    @Override
    protected Void run() {
        ArrayList<Object> entries = new ArrayList<SendMessageBatchRequestEntry>(10);
        ArrayList<String> rejectedDatabeans = new ArrayList<String>();
        int currentPayloadSize = 0;
        for (Databean databean : this.databeans) {
            FieldGeneratorTool.generateAndSetValueForFieldIfNecessary((PhysicalDatabeanFieldInfo)this.fieldInfo, (Databean)databean);
            String databeanAsString = this.codec.toString(databean, this.fielder);
            int encodedDatabeanSize = StringCodec.UTF_8.encode(databeanAsString).length;
            if (encodedDatabeanSize > CommonFieldSizes.MAX_SQS_SIZE) {
                rejectedDatabeans.add(databeanAsString);
                continue;
            }
            if (currentPayloadSize + encodedDatabeanSize > CommonFieldSizes.MAX_SQS_SIZE || entries.size() >= 10) {
                this.putBatch(entries);
                entries = new ArrayList();
                currentPayloadSize = 0;
            }
            entries.add(new SendMessageBatchRequestEntry(UUID.randomUUID().toString(), databeanAsString));
            currentPayloadSize += encodedDatabeanSize;
        }
        if (!entries.isEmpty()) {
            this.putBatch(entries);
        }
        if (!rejectedDatabeans.isEmpty()) {
            throw new SqsDataTooLargeException(rejectedDatabeans);
        }
        return null;
    }

    private void putBatch(List<SendMessageBatchRequestEntry> entries) {
        SendMessageBatchRequest request = new SendMessageBatchRequest(this.queueUrl, entries);
        try {
            this.sqsClientManager.getAmazonSqs(this.clientId).sendMessageBatch(request);
        }
        catch (AbortedException e) {
            throw new UncheckedInterruptedException("", (Exception)((Object)e));
        }
    }
}

