/*
 * Decompiled with CFR 0.152.
 */
package io.datarouter.aws.sqs.single.op;

import com.amazonaws.services.sqs.model.Message;
import com.amazonaws.services.sqs.model.MessageAttributeValue;
import io.datarouter.aws.sqs.BaseSqsNode;
import io.datarouter.aws.sqs.SqsClientManager;
import io.datarouter.aws.sqs.op.BaseSqsPeekMultiOp;
import io.datarouter.bytes.codec.stringcodec.StringCodec;
import io.datarouter.model.databean.Databean;
import io.datarouter.model.key.primary.PrimaryKey;
import io.datarouter.model.serialize.fielder.DatabeanFielder;
import io.datarouter.scanner.Scanner;
import io.datarouter.storage.client.ClientId;
import io.datarouter.storage.config.Config;
import io.datarouter.storage.queue.QueueMessage;
import java.util.List;
import java.util.Map;

public class SqsPeekMultiOp<PK extends PrimaryKey<PK>, D extends Databean<PK, D>, F extends DatabeanFielder<PK, D>>
extends BaseSqsPeekMultiOp<PK, D, F, QueueMessage<PK, D>> {
    public SqsPeekMultiOp(Config config, BaseSqsNode<PK, D, F> sqsNode, SqsClientManager sqsClientManager, ClientId clientId) {
        super(config, sqsNode, sqsClientManager, clientId);
    }

    @Override
    protected List<QueueMessage<PK, D>> extractDatabeans(List<Message> messages) {
        return messages.stream().map(message -> {
            Databean databean = this.codec.fromString(message.getBody(), this.fielder, this.databeanSupplier);
            byte[] receiptHandle = StringCodec.UTF_8.encode(message.getReceiptHandle());
            Map attributes = Scanner.of(message.getMessageAttributes().entrySet()).toMap(Map.Entry::getKey, entry -> ((MessageAttributeValue)entry.getValue()).getStringValue());
            return new QueueMessage(receiptHandle, databean, attributes);
        }).toList();
    }
}

