/*
 * Decompiled with CFR 0.152.
 */
package io.datarouter.aws.sqs.service;

import io.datarouter.aws.sqs.SqsClientType;
import io.datarouter.aws.sqs.service.SqsQueueRegistryService;
import io.datarouter.email.html.J2HtmlEmailTable;
import io.datarouter.instrumentation.relay.rml.Rml;
import io.datarouter.instrumentation.relay.rml.RmlBlock;
import io.datarouter.scanner.Scanner;
import io.datarouter.storage.client.ClientId;
import io.datarouter.storage.client.DatarouterClients;
import io.datarouter.web.config.DatarouterWebPaths;
import io.datarouter.web.digest.DailyDigest;
import io.datarouter.web.digest.DailyDigestGrouping;
import io.datarouter.web.digest.DailyDigestService;
import j2html.TagCreator;
import j2html.tags.DomContent;
import j2html.tags.specialized.DivTag;
import j2html.tags.specialized.H3Tag;
import j2html.tags.specialized.TableTag;
import jakarta.inject.Inject;
import jakarta.inject.Singleton;
import java.time.ZoneId;
import java.util.List;
import java.util.Optional;

@Singleton
public class SqsQueuesDailyDigest
implements DailyDigest {
    @Inject
    private DatarouterClients datarouterClients;
    @Inject
    private DatarouterWebPaths paths;
    @Inject
    private SqsQueueRegistryService queueRegistryService;
    @Inject
    private DailyDigestService digestService;

    public String getTitle() {
        return "Sqs Queues";
    }

    public DailyDigest.DailyDigestType getType() {
        return DailyDigest.DailyDigestType.ACTIONABLE;
    }

    public DailyDigestGrouping getGrouping() {
        return DailyDigestGrouping.LOW;
    }

    public Optional<DivTag> getEmailContent(ZoneId zoneId) {
        ClientId clientId = Scanner.of((Iterable)this.datarouterClients.getClientIds()).include(client -> this.datarouterClients.getClientTypeInstance(client) instanceof SqsClientType).findFirst().orElse(null);
        if (clientId == null) {
            return Optional.empty();
        }
        List<String> unreferencedQueues = this.queueRegistryService.getSqsQueuesForClient(clientId).unreferencedQueues();
        if (unreferencedQueues.isEmpty()) {
            return Optional.empty();
        }
        TableTag unreferencedQueuesTable = new J2HtmlEmailTable().withColumn("Queue Name", row -> row).build(unreferencedQueues);
        H3Tag header = this.digestService.makeHeader("Unreferenced Sqs Queues", this.paths.datarouter.client.inspectClient, "?clientName=sqs");
        return Optional.of(TagCreator.div((DomContent[])new DomContent[]{header, unreferencedQueuesTable}));
    }

    public Optional<RmlBlock> getRelayContent(ZoneId zoneId) {
        ClientId clientId = Scanner.of((Iterable)this.datarouterClients.getClientIds()).include(client -> this.datarouterClients.getClientTypeInstance(client) instanceof SqsClientType).findFirst().orElse(null);
        if (clientId == null) {
            return Optional.empty();
        }
        List<String> unreferencedQueues = this.queueRegistryService.getSqsQueuesForClient(clientId).unreferencedQueues();
        if (unreferencedQueues.isEmpty()) {
            return Optional.empty();
        }
        return Optional.of(Rml.paragraph((RmlBlock[])new RmlBlock[]{this.digestService.makeHeading("Unreferenced Sqs Queues", this.paths.datarouter.client.inspectClient, "?clientName=sqs"), Rml.table((RmlBlock[])new RmlBlock[]{Rml.tableRow((RmlBlock[])new RmlBlock[]{Rml.tableHeader((RmlBlock[])new RmlBlock[]{Rml.text((String)"Queue Name")})})}).with(unreferencedQueues.stream().map(Rml::text).map(rmlText -> Rml.tableCell((RmlBlock[])new RmlBlock[]{rmlText})).map(rmlTableCell -> Rml.tableRow((RmlBlock[])new RmlBlock[]{rmlTableCell})))}));
    }
}

