/*
 * Decompiled with CFR 0.152.
 */
package io.datarouter.aws.sqs.service;

import com.amazonaws.services.sqs.AmazonSQS;
import com.amazonaws.services.sqs.model.QueueDoesNotExistException;
import io.datarouter.aws.sqs.SqsClientManager;
import io.datarouter.aws.sqs.SqsPhysicalNode;
import io.datarouter.aws.sqs.SqsQueueNameService;
import io.datarouter.aws.sqs.config.DatarouterSqsPlugin;
import io.datarouter.aws.sqs.service.QueueUrlAndName;
import io.datarouter.plugin.PluginInjector;
import io.datarouter.scanner.Scanner;
import io.datarouter.storage.client.ClientId;
import io.datarouter.storage.config.properties.ServiceName;
import io.datarouter.storage.node.DatarouterNodes;
import io.datarouter.storage.node.NodeTool;
import io.datarouter.util.string.StringTool;
import jakarta.inject.Inject;
import jakarta.inject.Singleton;
import java.util.HashSet;
import java.util.List;
import java.util.Set;
import java.util.function.Supplier;

@Singleton
public class SqsQueueRegistryService {
    @Inject
    private DatarouterNodes nodes;
    @Inject
    private SqsClientManager sqsClientManager;
    @Inject
    private SqsQueueNameService sqsQueueNameService;
    @Inject
    private PluginInjector pluginInjector;
    @Inject
    private ServiceName serviceName;

    public SqsQueuesForClient getSqsQueuesForClient(ClientId clientId) {
        AmazonSQS sqs = this.sqsClientManager.getAmazonSqs(clientId);
        List knownQueueUrlAndNames = Scanner.of((Iterable)this.nodes.getPhysicalNodesForClient(clientId.getName())).map(NodeTool::extractSinglePhysicalNode).map(physicalNode -> (SqsPhysicalNode)physicalNode).map(SqsPhysicalNode::getQueueUrlAndName).map(Supplier::get).list();
        Set knownQueuesUrls = (Set)Scanner.of((Iterable)knownQueueUrlAndNames).map(QueueUrlAndName::queueUrl).collect(HashSet::new);
        List unreferencedQueues = Scanner.of((Iterable)sqs.listQueues(this.sqsQueueNameService.buildDefaultNamespace()).getQueueUrls()).exclude(queueUrl -> this.checkForUnreferencedQueues((String)queueUrl, knownQueuesUrls)).map(queueUrl -> StringTool.getStringAfterLastOccurrence((String)"/", (String)queueUrl)).include(queueName -> this.sqsQueueExists(sqs, (String)queueName)).list();
        return new SqsQueuesForClient(knownQueueUrlAndNames, unreferencedQueues);
    }

    private boolean checkForUnreferencedQueues(String queueUrl, Set<String> knownQueuesUrls) {
        return Scanner.of(((DatarouterSqsPlugin.ServiceNameRegistry)this.pluginInjector.getInstance(DatarouterSqsPlugin.ServiceNameRegistry.KEY)).serviceNames).exclude(name -> name.equals(this.serviceName.get())).anyMatch(serviceName -> queueUrl.contains((CharSequence)serviceName) || knownQueuesUrls.contains(queueUrl));
    }

    private boolean sqsQueueExists(AmazonSQS sqs, String queueName) {
        try {
            sqs.getQueueUrl(queueName);
            return true;
        }
        catch (QueueDoesNotExistException e) {
            return false;
        }
    }

    public record SqsQueuesForClient(List<QueueUrlAndName> knownQueueUrlByName, List<String> unreferencedQueues) {
    }
}

