/*
 * Decompiled with CFR 0.152.
 */
package io.datarouter.aws.sqs.group.op;

import com.amazonaws.services.sqs.model.Message;
import io.datarouter.aws.sqs.BaseSqsNode;
import io.datarouter.aws.sqs.SqsClientManager;
import io.datarouter.aws.sqs.op.BaseSqsPeekMultiOp;
import io.datarouter.bytes.codec.stringcodec.StringCodec;
import io.datarouter.model.databean.Databean;
import io.datarouter.model.key.primary.PrimaryKey;
import io.datarouter.model.serialize.fielder.DatabeanFielder;
import io.datarouter.storage.client.ClientId;
import io.datarouter.storage.config.Config;
import io.datarouter.storage.queue.GroupQueueMessage;
import java.util.List;

public class SqsGroupPeekMultiOp<PK extends PrimaryKey<PK>, D extends Databean<PK, D>, F extends DatabeanFielder<PK, D>>
extends BaseSqsPeekMultiOp<PK, D, F, GroupQueueMessage<PK, D>> {
    public SqsGroupPeekMultiOp(Config config, BaseSqsNode<PK, D, F> sqsNode, SqsClientManager sqsClientManager, ClientId clientId) {
        super(config, sqsNode, sqsClientManager, clientId);
    }

    @Override
    protected List<GroupQueueMessage<PK, D>> extractDatabeans(List<Message> messages) {
        return messages.stream().map(message -> {
            List databeans = this.codec.fromStringMulti(message.getBody(), this.fielder, this.databeanSupplier);
            byte[] receiptHandle = StringCodec.UTF_8.encode(message.getReceiptHandle());
            return new GroupQueueMessage(receiptHandle, databeans);
        }).toList();
    }
}

