/*
 * Decompiled with CFR 0.152.
 */
package io.datarouter.aws.sqs.blob;

import com.amazonaws.services.sqs.model.CreateQueueRequest;
import com.amazonaws.services.sqs.model.QueueAttributeName;
import io.datarouter.aws.sqs.BaseSqsNode;
import io.datarouter.aws.sqs.SqsBlobOpFactory;
import io.datarouter.aws.sqs.SqsClientManager;
import io.datarouter.aws.sqs.SqsPhysicalNode;
import io.datarouter.aws.sqs.SqsQueueNameService;
import io.datarouter.aws.sqs.service.QueueUrlAndName;
import io.datarouter.bytes.Codec;
import io.datarouter.bytes.codec.bytestringcodec.Base64ByteStringCodec;
import io.datarouter.model.databean.EmptyDatabean;
import io.datarouter.model.key.EmptyDatabeanKey;
import io.datarouter.model.util.CommonFieldSizes;
import io.datarouter.storage.client.ClientId;
import io.datarouter.storage.client.ClientType;
import io.datarouter.storage.config.Config;
import io.datarouter.storage.node.NodeParams;
import io.datarouter.storage.node.op.raw.BlobQueueStorage;
import io.datarouter.storage.node.type.physical.base.BasePhysicalNode;
import io.datarouter.storage.queue.BlobQueueMessage;
import io.datarouter.util.singletonsupplier.SingletonSupplier;
import java.time.Duration;
import java.util.Optional;
import java.util.function.Supplier;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;

public class SqsBlobNode<T>
extends BasePhysicalNode<EmptyDatabeanKey, EmptyDatabean, EmptyDatabean.EmptyDatabeanFielder>
implements BlobQueueStorage.PhysicalBlobQueueStorageNode<T>,
SqsPhysicalNode<EmptyDatabeanKey, EmptyDatabean, EmptyDatabean.EmptyDatabeanFielder> {
    private static final Logger logger = LoggerFactory.getLogger(SqsBlobNode.class);
    private final String queueName;
    private final NodeParams<EmptyDatabeanKey, EmptyDatabean, EmptyDatabean.EmptyDatabeanFielder> params;
    private final Codec<T, byte[]> codec;
    private final SqsClientManager sqsClientManager;
    private final ClientId clientId;
    private final boolean owned;
    private final Supplier<QueueUrlAndName> queueUrlAndName;
    private final SqsBlobOpFactory opFactory;

    public SqsBlobNode(SqsQueueNameService sqsQueueNameService, NodeParams<EmptyDatabeanKey, EmptyDatabean, EmptyDatabean.EmptyDatabeanFielder> params, Codec<T, byte[]> codec, ClientType<?, ?> clientType, SqsClientManager sqsClientManager) {
        super(params, clientType);
        this.queueName = sqsQueueNameService.buildQueueName(params.getQueueUrl(), this.getFieldInfo().getTableName());
        this.params = params;
        this.codec = codec;
        this.sqsClientManager = sqsClientManager;
        this.clientId = params.getClientId();
        this.owned = params.getQueueUrl() == null;
        this.queueUrlAndName = SingletonSupplier.of(this::getOrCreateQueueUrl);
        this.opFactory = new SqsBlobOpFactory(this, sqsClientManager, this.clientId);
    }

    private QueueUrlAndName getOrCreateQueueUrl() {
        String queueUrl;
        if (this.owned) {
            queueUrl = this.createQueueAndGetUrl(this.queueName);
            this.sqsClientManager.updateAttr(this.clientId, queueUrl, QueueAttributeName.MessageRetentionPeriod, BaseSqsNode.RETENTION_S);
            logger.warn("retention updated queueName={}", (Object)this.queueName);
        } else {
            queueUrl = this.params.getQueueUrl();
        }
        logger.warn("nodeName={}, queueUrl={}", (Object)this.getName(), (Object)queueUrl);
        return new QueueUrlAndName(queueUrl, this.queueName);
    }

    private String createQueueAndGetUrl(String queueName) {
        CreateQueueRequest createQueueRequest = new CreateQueueRequest(queueName);
        try {
            return this.sqsClientManager.getAmazonSqs(this.clientId).createQueue(createQueueRequest).getQueueUrl();
        }
        catch (RuntimeException e) {
            throw new RuntimeException("queueName=" + queueName + " queueNameLength=" + queueName.length(), e);
        }
    }

    @Override
    public Supplier<QueueUrlAndName> getQueueUrlAndName() {
        return this.queueUrlAndName;
    }

    @Override
    public boolean getAgeMonitoringStatusForMetricAlert() {
        return this.params.getAgeMonitoringStatus();
    }

    @Override
    public Duration getCustomMessageAgeThreshold() {
        return this.params.getCustomMessageAgeThreshold();
    }

    public int getMaxRawDataSize() {
        return Base64ByteStringCodec.getMaxByteLength((int)CommonFieldSizes.MAX_SQS_SIZE);
    }

    public Codec<T, byte[]> getCodec() {
        return this.codec;
    }

    public void putRaw(byte[] data, Config config) {
        this.opFactory.makePutOp(data, config).call();
    }

    public Optional<BlobQueueMessage<T>> peek(Config config) {
        return Optional.ofNullable(this.opFactory.makePeekOp(config).call()).map(rawDto -> new BlobQueueMessage(rawDto, this.codec));
    }

    public void ack(byte[] handle, Config config) {
        this.opFactory.makeAckOp(handle, config).call();
    }
}

